/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.commons.cluster.loadbalancer.ClusterAPI;
import com.actionsoft.bpms.commons.seq.ClusterFactory;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.exception.AWSDataAccessException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Sequence {
    private static final int STEP_DEF = 20;
    private static final Map<String, Integer> STEP_V = new HashMap<String, Integer>();
    private static Map<String, AtomicLong> _STEP = new HashMap<String, AtomicLong>();
    private static Map<String, AtomicInteger> _STEP_POINTER = new HashMap<String, AtomicInteger>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextValue(String sequenceName) throws AWSDataAccessException {
        if (ClusterAPI.isCluster()) {
            return ClusterFactory.getSEQImpl().getSEQ(sequenceName);
        }
        String string = sequenceName;
        synchronized (string) {
            AtomicLong now = _STEP.get(sequenceName);
            if (now == null) {
                long seq = Sequence.getSeq(sequenceName) + 1L;
                Sequence.updateSeq(sequenceName);
                _STEP.put(sequenceName, new AtomicLong(seq));
                return seq;
            }
            int pointer = _STEP_POINTER.get(sequenceName).decrementAndGet();
            if (pointer == 0) {
                Sequence.updateSeq(sequenceName);
            }
            return now.incrementAndGet();
        }
    }

    private static long getSeq(String sequenceName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("SEQUENCENAME", sequenceName);
        long seq = DBSql.getLong("SELECT SEQUENCEVALUE FROM SYS_SEQUENCE WHERE SEQUENCENAME=:SEQUENCENAME", "SEQUENCEVALUE", params);
        if (seq < 1L) {
            Sequence.createSequenceKey(sequenceName);
            seq = 0L;
        }
        return seq;
    }

    private static int updateSeq(String sequenceName) {
        int step = Sequence.getStep(sequenceName);
        int t = DBSql.update("UPDATE SYS_SEQUENCE SET SEQUENCEVALUE= SEQUENCEVALUE+? WHERE SEQUENCENAME=?", new Object[]{step, sequenceName});
        _STEP_POINTER.put(sequenceName, new AtomicInteger(step));
        return t;
    }

    public static void rest(String sequenceName) throws AWSDataAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SEQUENCENAME", sequenceName);
        DBSql.update("UPDATE SYS_SEQUENCE SET SEQUENCEVALUE=0 WHERE SEQUENCENAME=:SEQUENCENAME", map);
    }

    public static void remove(String sequenceName) throws AWSDataAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SEQUENCENAME", sequenceName);
        DBSql.update("DELETE FROM SYS_SEQUENCE WHERE SEQUENCENAME=:SEQUENCENAME", map);
    }

    private static int createSequenceKey(String sequenceName) throws AWSDataAccessException {
        if (sequenceName.length() > 100) {
            throw new AWSDataAccessException("\u8d85\u51faSequenceName\u547d\u540d\u7684\u6700\u5927\u957f\u5ea6");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SEQUENCENAME", sequenceName);
        map.put("SEQUENCEVALUE", 1);
        map.put("CACHESTEP", 0);
        String sql = DBSql.getInsertStatement("SYS_SEQUENCE", map);
        return DBSql.update(sql, map);
    }

    private static int getStep(String sequenceName) {
        Integer step = STEP_V.get(sequenceName);
        return step == null ? 20 : step;
    }
}

