/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class StringTool {
    public static String chineseToPinyin(String chinese) {
        if (chinese == null || "".equals(chinese)) {
            return "";
        }
        String str = "";
        char[] cs = chinese.toCharArray();
        HanyuPinyinOutputFormat hpof = new HanyuPinyinOutputFormat();
        hpof.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        hpof.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        hpof.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
        try {
            int i = 0;
            while (i < cs.length) {
                String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)cs[i], (HanyuPinyinOutputFormat)hpof);
                if (strs != null) {
                    str = String.valueOf(str) + strs[0];
                }
                ++i;
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return str;
    }

    public static String chineseToInitial(String chinese) {
        if (chinese == null || "".equals(chinese)) {
            return "";
        }
        String str = "";
        char[] cs = chinese.toCharArray();
        HanyuPinyinOutputFormat hpof = new HanyuPinyinOutputFormat();
        hpof.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        hpof.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        hpof.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
        try {
            int i = 0;
            while (i < cs.length) {
                String[] strs = PinyinHelper.toHanyuPinyinStringArray((char)cs[i], (HanyuPinyinOutputFormat)hpof);
                str = strs != null ? String.valueOf(str) + strs[0].substring(0, 1) : String.valueOf(str) + cs[i];
                ++i;
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return str.toUpperCase();
    }

    public static String arrayToString(String[] array, String sign) {
        if (array == null) {
            array = new String[]{};
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            sb.append(str).append(sign);
            ++n2;
        }
        return sb.substring(0, sb.length() - sign.length());
    }
}

