/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.server.monitor.ThreadMonit;
import com.actionsoft.bpms.util.AWSThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadMgr {
    private static BlockingQueue<Runnable> BQ = new ArrayBlockingQueue<Runnable>(20000);
    private static ExecutorService threadExecutor = new ThreadPoolExecutor(20, 80, 60L, TimeUnit.SECONDS, BQ, new AWSThreadFactory());

    public static void execute(Runnable command) {
        threadExecutor.execute(new InnerR(command));
    }

    public static Future<?> submit(Runnable command) {
        return threadExecutor.submit(new InnerR(command));
    }

    public static <T> Future<T> submit(Callable<T> command) {
        return threadExecutor.submit(new InnerC<T>(command));
    }

    public static ExecutorService getExecutor() {
        return threadExecutor;
    }

    public static void close() {
        if (threadExecutor != null) {
            threadExecutor.shutdown();
            while (!threadExecutor.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 15) {
            System.out.println(BQ.size());
            ThreadMgr.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ++i;
        }
    }

    private static class InnerC<V>
    implements Callable<V> {
        private Callable<V> r;

        public InnerC(Callable<V> r) {
            this.r = r;
        }

        @Override
        public V call() throws Exception {
            ThreadMonit.start((int)4, (Object[])new Object[0]);
            try {
                V v = this.r.call();
                return v;
            }
            finally {
                ThreadMonit.end();
            }
        }
    }

    private static class InnerR
    implements Runnable {
        public Runnable r;

        private InnerR(Runnable r) {
            this.r = r;
        }

        @Override
        public void run() {
            ThreadMonit.start((int)4, (Object[])new Object[0]);
            try {
                this.r.run();
            }
            finally {
                ThreadMonit.end();
            }
        }
    }
}

