/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ThreadStackTraceInfo {
    public static String lineSeparator = "\n";

    static {
        lineSeparator = System.getProperty("line.separator", "/n");
    }

    public static String getCurrentThreadStackTraces() {
        return ThreadStackTraceInfo.getThreadStackTraces(Thread.currentThread());
    }

    public static String getCurrentThreadStackTraces(int firstLevel) {
        return ThreadStackTraceInfo.getThreadStackTraces(Thread.currentThread(), firstLevel);
    }

    public static String getThreadStackTraces(Thread t) {
        return ThreadStackTraceInfo.getThreadStackTraces(t, 0);
    }

    public static List<String> getStackArray(Thread t) {
        return ThreadStackTraceInfo.getThreadStackTracesArray(t, 0);
    }

    public static List<String> getStackArray(Map<Thread, StackTraceElement[]> activeThreads, Thread t) {
        return ThreadStackTraceInfo.getThreadStackTracesArray(activeThreads, t, 0);
    }

    public static List<String> getThreadStackTracesArray(Thread t, int firstLevel) {
        Map<Thread, StackTraceElement[]> activeThreads = Thread.getAllStackTraces();
        List<String> list = ThreadStackTraceInfo.getThreadStackTracesArray(activeThreads, t, firstLevel);
        activeThreads = null;
        return list;
    }

    public static List<String> getThreadStackTracesArray(Map<Thread, StackTraceElement[]> activeThreads, Thread t, int firstLevel) {
        ArrayList<String> value = new ArrayList<String>();
        StackTraceElement[] stacks = activeThreads.get(t);
        if (stacks != null) {
            int ii = firstLevel;
            while (ii < stacks.length) {
                if (stacks[ii].getLineNumber() <= 0) {
                    value.add(String.valueOf(stacks[ii].getClassName()) + "." + stacks[ii].getMethodName() + "()");
                } else {
                    value.add(String.valueOf(stacks[ii].getClassName()) + "." + stacks[ii].getMethodName() + "()\u7b2c" + stacks[ii].getLineNumber() + "\u884c");
                }
                ++ii;
            }
            value.add("\u8bb0\u5f55\u65f6\u95f4\uff1a" + UtilDate.datetimeFormat(new Date()));
        }
        return value;
    }

    public static String getThreadStackTraces(Thread t, int firstLevel) {
        List<String> ss = ThreadStackTraceInfo.getThreadStackTracesArray(t, firstLevel);
        return UtilString.join(ss, lineSeparator);
    }
}

