/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.bo.design.model.BOItemModel;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.exception.AWSException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverterManager;

public class TypeUtil {
    public static String convert(BOItemModel boItemModel, Object o) {
        String value = "";
        if (boItemModel.getColumnType().equals("DATE")) {
            if (boItemModel.getComponentId().equals("AWSUI.Date")) {
                if (o instanceof Date) {
                    value = UtilDate.dateFormat((Date)o);
                } else if (o instanceof Timestamp) {
                    value = UtilDate.dateFormat((Timestamp)o);
                }
            } else if (boItemModel.getComponentId().equals("AWSUI.DateTime")) {
                if (o instanceof Date) {
                    value = UtilDate.datetimeFormat((Date)o);
                } else if (o instanceof Timestamp) {
                    value = UtilDate.datetimeFormat((Timestamp)o);
                }
            }
        } else if (boItemModel.getColumnType().equals("NUMBER")) {
            String string = value = o == null ? "" : o.toString();
            if (value == null) {
                value = "0";
            }
            if (value.indexOf(".") == 0) {
                value = "0" + value;
            }
        } else {
            value = o == null ? "" : o.toString();
        }
        return value;
    }

    public static <T> T convert(Object v, Class<T> target) {
        try {
            return (T)TypeConverterManager.convertType((Object)v, target);
        }
        catch (TypeConversionException e) {
            if (Timestamp.class == target) {
                if (v == null) {
                    return null;
                }
                String str = (String)v;
                if (str.indexOf(" ") > 0) {
                    return target.cast(UtilDate.parseTsFromDateTime(str));
                }
                return target.cast(UtilDate.parseTsFromDate(str));
            }
            if (Date.class == target) {
                if (v == null) {
                    return null;
                }
                String str = (String)v;
                if (str.indexOf(" ") > 0) {
                    return target.cast(UtilDate.parseDatetime(str));
                }
                return target.cast(UtilDate.parse(str));
            }
            throw new AWSException("\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c" + v + "->" + target, e);
        }
    }

    public static <T> Collection<T> convertToCollection(Object value, Class<? extends Collection<T>> destinationType, Class componentType) {
        return TypeConverterManager.convertToCollection((Object)value, destinationType, (Class)componentType);
    }
}

