/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSException;
import com.actionsoft.i18n.I18nRes;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class UtilDate {
    public static Date parse(String dateStr, String format) {
        if (dateStr.length() == 0) {
            return null;
        }
        if (format.length() == 0) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            throw new AWSException(e);
        }
        return date;
    }

    public static Date parse(String dateStr) {
        if (dateStr.length() == 0) {
            return null;
        }
        String format = "yyyy-MM-dd";
        return UtilDate.parse(dateStr, format);
    }

    public static Date parseDatetime(String dateStr) {
        if (UtilString.isEmpty(dateStr)) {
            return null;
        }
        String format = "yyyy-MM-dd HH:mm:ss";
        return UtilDate.parse(dateStr, format);
    }

    public static Timestamp parseTs(String dateStr, String format) {
        Timestamp ts = null;
        Date date = null;
        date = UtilDate.parse(dateStr, format);
        if (date == null) {
            return null;
        }
        ts = new Timestamp(date.getTime());
        return ts;
    }

    public static Timestamp parseTsFromDate(String dateStr) {
        String format = "yyyy-MM-dd";
        Date date = UtilDate.parse(dateStr, format);
        if (date == null) {
            return null;
        }
        Timestamp ts = null;
        ts = new Timestamp(date.getTime());
        return ts;
    }

    public static Timestamp parseTsFromDateTime(String dateStr) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if ((dateStr = dateStr.replace("T", " ")).length() < 11) {
            dateStr = String.valueOf(dateStr) + " 00:00:00";
        } else if (dateStr.length() < 14) {
            dateStr = String.valueOf(dateStr) + ":00:00";
        } else if (dateStr.length() < 18) {
            dateStr = String.valueOf(dateStr) + ":00";
        }
        Date date = UtilDate.parse(dateStr, format);
        if (date == null) {
            return null;
        }
        Timestamp ts = null;
        ts = new Timestamp(date.getTime());
        return ts;
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        switch (gc.get(7)) {
            case 1: {
                gc.add(5, 0);
                break;
            }
            case 2: {
                gc.add(5, -1);
                break;
            }
            case 3: {
                gc.add(5, -2);
                break;
            }
            case 4: {
                gc.add(5, -3);
                break;
            }
            case 5: {
                gc.add(5, -4);
                break;
            }
            case 6: {
                gc.add(5, -5);
                break;
            }
            case 7: {
                gc.add(5, -6);
            }
        }
        return gc.getTime();
    }

    public static Calendar getLastDayOfWeekMon2Fri(Calendar gc) {
        switch (gc.get(7)) {
            case 1: {
                gc.add(5, 6);
                break;
            }
            case 2: {
                gc.add(5, 5);
                break;
            }
            case 3: {
                gc.add(5, 4);
                break;
            }
            case 4: {
                gc.add(5, 3);
                break;
            }
            case 5: {
                gc.add(5, 2);
                break;
            }
            case 6: {
                gc.add(5, 1);
                break;
            }
            case 7: {
                gc.add(5, 0);
            }
        }
        gc.add(5, -1);
        return gc;
    }

    public static Calendar getFirstDayOfWeekMon2Fri(Calendar gc) {
        switch (gc.get(7)) {
            case 1: {
                gc.add(5, 0);
                break;
            }
            case 2: {
                gc.add(5, -1);
                break;
            }
            case 3: {
                gc.add(5, -2);
                break;
            }
            case 4: {
                gc.add(5, -3);
                break;
            }
            case 5: {
                gc.add(5, -4);
                break;
            }
            case 6: {
                gc.add(5, -5);
                break;
            }
            case 7: {
                gc.add(5, -6);
            }
        }
        gc.add(5, 1);
        return gc;
    }

    public static Date getFirstDayOfMonth(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        gc.set(5, 1);
        return gc.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        switch (gc.get(2)) {
            case 0: {
                gc.set(5, 31);
                break;
            }
            case 1: {
                gc.set(5, 28);
                break;
            }
            case 2: {
                gc.set(5, 31);
                break;
            }
            case 3: {
                gc.set(5, 30);
                break;
            }
            case 4: {
                gc.set(5, 31);
                break;
            }
            case 5: {
                gc.set(5, 30);
                break;
            }
            case 6: {
                gc.set(5, 31);
                break;
            }
            case 7: {
                gc.set(5, 31);
                break;
            }
            case 8: {
                gc.set(5, 30);
                break;
            }
            case 9: {
                gc.set(5, 31);
                break;
            }
            case 10: {
                gc.set(5, 30);
                break;
            }
            case 11: {
                gc.set(5, 31);
            }
        }
        if (gc.get(2) == 1 && UtilDate.isLeapYear(gc.get(1))) {
            gc.set(5, 29);
        }
        return gc.getTime();
    }

    public static boolean isLeapYear(int year) {
        if (year % 400 == 0) {
            return true;
        }
        if (year % 4 == 0) {
            return year % 100 != 0;
        }
        return false;
    }

    public static Calendar getFirstDayOfNextMonth(Calendar gc) {
        gc.setTime(UtilDate.getNextMonth(gc.getTime()));
        gc.setTime(UtilDate.getFirstDayOfMonth(gc.getTime()));
        return gc;
    }

    public static Date getFirstDayOfNextMonth(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        gc.setTime(UtilDate.getNextMonth(gc.getTime()));
        gc.setTime(UtilDate.getFirstDayOfMonth(gc.getTime()));
        return gc.getTime();
    }

    public static synchronized Calendar getFirstDayOfNextWeek(Calendar gc) {
        gc.setTime(UtilDate.getNextWeek(gc.getTime()));
        gc.setTime(UtilDate.getFirstDayOfWeek(gc.getTime()));
        return gc;
    }

    public static Date getFirstDayOfNextWeek(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        gc.setTime(UtilDate.getNextWeek(gc.getTime()));
        gc.setTime(UtilDate.getFirstDayOfWeek(gc.getTime()));
        return gc.getTime();
    }

    public static Calendar getNextDay(Calendar gc) {
        gc.add(5, 1);
        return gc;
    }

    public static synchronized Date getNextDay(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        gc.add(5, 1);
        return gc.getTime();
    }

    public static Calendar getNextMonth(Calendar gc) {
        gc.add(2, 1);
        return gc;
    }

    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        switch (gc.get(7)) {
            case 1: {
                gc.add(5, 6);
                break;
            }
            case 2: {
                gc.add(5, 5);
                break;
            }
            case 3: {
                gc.add(5, 4);
                break;
            }
            case 4: {
                gc.add(5, 3);
                break;
            }
            case 5: {
                gc.add(5, 2);
                break;
            }
            case 6: {
                gc.add(5, 1);
                break;
            }
            case 7: {
                gc.add(5, 0);
            }
        }
        return gc.getTime();
    }

    public static Date getNextMonth(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        gc.add(2, 1);
        return gc.getTime();
    }

    public static Calendar getNextWeek(Calendar gc) {
        gc.add(5, 7);
        return gc;
    }

    public static Date getNextWeek(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        gc.add(5, 7);
        return gc.getTime();
    }

    public static Calendar getNextWeekDay(Calendar gc) {
        switch (gc.get(7)) {
            case 6: {
                gc.add(5, 3);
                break;
            }
            case 7: {
                gc.add(5, 2);
                break;
            }
            default: {
                gc.add(5, 1);
            }
        }
        return gc;
    }

    public static long getTimes(String text) {
        return UtilDate.getTimes(text, "yyyy-MM-dd");
    }

    public static long getTimes(String text, String format) {
        SimpleDateFormat datetimeFormat = new SimpleDateFormat(format);
        try {
            return datetimeFormat.parse(text).getTime();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return 0L;
        }
    }

    public static String yearFormat(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy");
        return datetimeFormat.format(date);
    }

    public static String yearFormat(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy");
        return datetimeFormat.format(new Date(timestamp.getTime()));
    }

    public static String monthFormat(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("MM");
        return datetimeFormat.format(date);
    }

    public static String monthFormat(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("MM");
        return datetimeFormat.format(new Date(timestamp.getTime()));
    }

    public static String dayFormat(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("dd");
        return datetimeFormat.format(date);
    }

    public static String dayFormat(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("dd");
        return datetimeFormat.format(new Date(timestamp.getTime()));
    }

    public static String datetimeFormat(Date date) {
        if (UtilString.isEmpty(date)) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return datetimeFormat.format(date);
    }

    public static String datetimeFormat(Date date, String format, Locale locale) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat(format, locale);
        return datetimeFormat.format(date);
    }

    public static String datetimeFormat(Date date, String format) {
        return UtilDate.datetimeFormat(date, format, Locale.CHINA);
    }

    public static String datetimeFormat24(Date date) {
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return datetimeFormat.format(date);
    }

    public static String datetimeFormat2(Date date) {
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");
        return datetimeFormat.format(date);
    }

    public static String datetimeFormat(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return datetimeFormat.format(new Date(timestamp.getTime()));
    }

    public static String datetimeFormat24(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return datetimeFormat.format(new Date(timestamp.getTime()));
    }

    public static String datetimeFormat2(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return datetimeFormat.format(new Date(timestamp.getTime()));
    }

    public static String dateFormat(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd");
        return datetimeFormat.format(date);
    }

    public static String timeFormat(Date date) {
        return UtilDate.timeFormat(date, "HH:mm:ss");
    }

    public static String timeFormat(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat(format);
        return datetimeFormat.format(date);
    }

    public static String dateFormat(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyy-MM-dd");
        return datetimeFormat.format(new Date(timestamp.getTime()));
    }

    public static String monthDayFormat(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("MM-dd");
        return datetimeFormat.format(new Date(timestamp.getTime()));
    }

    public static int getDayOfWeek() {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        return UtilDate.getDayOfWeek(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5));
    }

    public static int getDayOfWeek(int year, int month, int day) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.set(year, --month, day);
        return gregorianCalendar.get(7);
    }

    public static String getDayOfWeekSymbols() {
        Locale cn = Locale.CHINA;
        return new DateFormatSymbols(cn).getWeekdays()[UtilDate.getDayOfWeek()];
    }

    public static String getDayOfWeekSymbols(int year, int month, int day) {
        Locale cn = Locale.CHINA;
        return new DateFormatSymbols(cn).getWeekdays()[UtilDate.getDayOfWeek(year, month, day)];
    }

    public static int getMaxDayOfMonth() {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        return UtilDate.getMaxDayOfMonth(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1);
    }

    public static int getMaxDayOfMonth(int year, int month) {
        --month;
        Calendar gregorianCalendar1 = GregorianCalendar.getInstance();
        Calendar gregorianCalendar2 = GregorianCalendar.getInstance();
        int i = 31;
        while (i > 27) {
            gregorianCalendar1.set(year, month, i);
            gregorianCalendar2.set(year, month, 1);
            if (gregorianCalendar1.get(2) == gregorianCalendar2.get(2)) {
                return i;
            }
            --i;
        }
        return 0;
    }

    public static int getWeekOfYear() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return UtilDate.getWeekOfYear(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5));
    }

    public static int getWeekOfYear(int year, int month, int day) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.set(year, --month, day);
        return gregorianCalendar.get(3);
    }

    public static int getQuarter(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        int m = gregorianCalendar.get(2) + 1;
        return UtilDate.getQuarterOfYear(m);
    }

    public static int getQuarterOfYear(int month) {
        if (month > 0 && month < 4) {
            return 1;
        }
        if (month > 3 && month < 7) {
            return 2;
        }
        if (month > 6 && month < 10) {
            return 3;
        }
        return 4;
    }

    public static int getQuarterOfYear() {
        return UtilDate.getQuarterOfYear(UtilDate.getMonth(new Date()));
    }

    public static int getYear(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(1);
    }

    public static int getHour(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(11);
    }

    public static int getMonth(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(5);
    }

    public static int getHourOfDay(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(11);
    }

    public static int getMinute(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(12);
    }

    public static String getAliasDatetime(Timestamp timestamp) {
        Date compareDate = new Date(timestamp.getTime());
        SimpleDateFormat timeFormat = new SimpleDateFormat("H:mm");
        String hourAndMin = timeFormat.format(compareDate);
        long compare = timestamp.getTime();
        long now = System.currentTimeMillis();
        Timestamp timestampNow = new Timestamp(now);
        double difOfHour = (double)(compare - now) / 3600000.0;
        int compareDay = UtilDate.getDay(timestamp);
        int currentDay = UtilDate.getDay(timestampNow);
        int compareYear = UtilDate.getYear(timestamp);
        int currentYear = UtilDate.getYear(timestampNow);
        int compareMonth = UtilDate.getMonth(timestamp);
        int currentMonth = UtilDate.getMonth(timestampNow);
        String appId = "_bpm.portal";
        String lang = "cn";
        try {
            lang = DispatcherRequest.getUserContext().getLanguage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compareYear == currentYear && compareMonth == currentMonth && compareDay == currentDay && Math.abs(difOfHour) > 1.0) {
            return String.valueOf(I18nRes.findValue(appId, "\u4eca\u5929")) + UtilDate.timeFormat(timestamp, "HH:mm");
        }
        return String.valueOf(UtilDate.getAliasDate(timestamp)) + UtilDate.timeFormat(timestamp, "HH:mm");
    }

    public static String getAliasDatetime(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Timestamp timestamp = null;
        try {
            timestamp = new Timestamp(format.parse(date).getTime());
        }
        catch (Exception e) {
            return date;
        }
        return UtilDate.getAliasDatetime(timestamp);
    }

    public static String getAliasDate(Timestamp timestamp) {
        long compare = timestamp.getTime();
        long now = System.currentTimeMillis();
        Timestamp timestampNow = new Timestamp(now);
        double difOfHour = (double)(compare - now) / 3600000.0;
        int compareDay = UtilDate.getDay(timestamp);
        int currentDay = UtilDate.getDay(timestampNow);
        int compareYear = UtilDate.getYear(timestamp);
        int currentYear = UtilDate.getYear(timestampNow);
        int compareMonth = UtilDate.getMonth(timestamp);
        int currentMonth = UtilDate.getMonth(timestampNow);
        Date compareDate = new Date(timestamp.getTime());
        String appId = "_bpm.portal";
        String lang = "cn";
        try {
            lang = DispatcherRequest.getUserContext().getLanguage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String result = "";
        if (compareYear == currentYear) {
            if (compareMonth == currentMonth) {
                if (compareDay == currentDay) {
                    if (Math.abs(difOfHour) <= 1.0) {
                        result = I18nRes.findValue(appId, "\u521a\u521a");
                    } else {
                        result = UtilDate.timeFormat(timestamp, "HH:mm");
                        if (result.equals("00:00")) {
                            result = I18nRes.findValue(appId, "\u4eca\u5929");
                        }
                    }
                } else {
                    long difOfDay = compareDay - currentDay;
                    result = difOfDay == -1L ? I18nRes.findValue(appId, "\u6628\u5929") : (difOfDay == -2L ? I18nRes.findValue(appId, "\u524d\u5929") : (difOfDay == 1L ? I18nRes.findValue(appId, "\u660e\u5929") : (lang.equals("en") ? UtilDate.datetimeFormat(compareDate, "MMM,d", Locale.US) : UtilDate.datetimeFormat(compareDate, "M\u6708d\u65e5"))));
                }
            } else {
                result = lang.equals("en") ? UtilDate.datetimeFormat(compareDate, "MMM,d", Locale.US) : UtilDate.datetimeFormat(compareDate, "M\u6708d\u65e5");
            }
        } else {
            int difOfYear;
            result = lang.equals("en") ? UtilDate.datetimeFormat(compareDate, "MMM,d", Locale.US) : ((difOfYear = compareYear - currentYear) == -1 ? UtilDate.datetimeFormat(compareDate, "\u53bb\u5e74M\u6708d\u65e5") : (difOfYear == -2 ? UtilDate.datetimeFormat(compareDate, "\u524d\u5e74M\u6708d\u65e5") : (difOfYear == 1 ? UtilDate.datetimeFormat(compareDate, "\u660e\u5e74M\u6708d\u65e5") : UtilDate.datetimeFormat(compareDate, "yyyy\u5e74M\u6708d\u65e5"))));
        }
        return result;
    }

    public static String getAliasDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Timestamp timestamp = null;
        try {
            timestamp = new Timestamp(format.parse(date).getTime());
        }
        catch (Exception e) {
            return date;
        }
        return UtilDate.getAliasDate(timestamp);
    }

    public static Calendar getCalendarByDayOfCurrentWeek(int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, day);
        calendar.add(7, 1);
        return calendar;
    }

    public static Calendar getCalendarByDayOfCurrentMonth(int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, day);
        return calendar;
    }

    public static Calendar getCalendarByCurrentQuarter(int month, int day) {
        Calendar calendar = Calendar.getInstance();
        int curMonth = calendar.get(2) + 1;
        int curQua = curMonth / 3 + 1;
        calendar.set(2, (curQua - 1) * 3 + month - 1);
        calendar.set(5, day);
        return calendar;
    }

    public static Calendar getCalendarByCurrentYear(int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, month - 1);
        calendar.set(5, day);
        return calendar;
    }

    public static Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis()));
        return calendar;
    }

    public static Calendar getCalendar(String date) {
        if (date == null || date.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat datetimeFormat = null;
        datetimeFormat = date.indexOf(":") > -1 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
        try {
            Calendar gregorianCalendar = GregorianCalendar.getInstance();
            gregorianCalendar.setTime(datetimeFormat.parse(date));
            return gregorianCalendar;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String s = "Meta|BBA|";
        System.out.println(s.replaceAll("A|", "C|"));
    }
}

