/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.commons.cache.FastFiles;
import com.actionsoft.bpms.server.fs.dc.DCUtil;
import com.actionsoft.bpms.util.UtilIO;
import com.actionsoft.exception.AWSDataAccessException;
import com.actionsoft.exception.AWSException;
import com.actionsoft.exception.AWSIllegalArgumentException;
import com.actionsoft.exception.ExceptionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;

public class UtilFile
extends File {
    private static final long serialVersionUID = -4670275211876789077L;
    private static Object _lock = new Object();
    private static Object _zipLock = new Object();

    public UtilFile(String pathname) {
        super(pathname);
    }

    public final String readStr() {
        byte[] data = this.readBytes();
        if (data == null) {
            return null;
        }
        return new String(data);
    }

    public final String readStrUTF8() {
        byte[] data = this.readBytes();
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    public final String readStr(String encoding) {
        byte[] data = this.readBytes();
        if (data == null) {
            return null;
        }
        try {
            return new String(data, encoding);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public final byte[] readBytes() {
        if (!this.exists()) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(this);
            int len = in.available();
            byte[] buf = new byte[len];
            in.read(buf, 0, len);
            byte[] byArray = buf;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public final List<String> readLines() {
        ArrayList<String> lines = new ArrayList<String>();
        FileReader reader = null;
        BufferedReader br = null;
        try {
            try {
                reader = new FileReader(this.getAbsolutePath());
                br = new BufferedReader(reader);
                String str = null;
                while ((str = br.readLine()) != null) {
                    lines.add(str);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    br.close();
                    reader.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                br.close();
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return lines;
    }

    public final int saveAs(String pathname) {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(this);
            os = new FileOutputStream(pathname);
            int n = UtilIO.copyAndCloseInput(is, os);
            return n;
        }
        catch (IOException e) {
            throw new AWSDataAccessException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public final boolean writeUTF8(String data) {
        return this.writeUTF8(data, false);
    }

    public final boolean writeUTF8(String data, boolean append) {
        try {
            return this.write(data.getBytes("UTF-8"), append);
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    public final boolean write(String data) {
        return this.write(data, false);
    }

    public final boolean write(String data, boolean append) {
        return this.write(data.getBytes(), append);
    }

    public final boolean write(byte[] data) {
        return this.write(data, false);
    }

    public final boolean write(byte[] data, boolean append) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this, append);
            fos.write(data);
            fos.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return false;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public final void printlnUTF8(String str, boolean append) {
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this, append), "utf-8"));
            pw.println(str);
            pw.close();
        }
        catch (IOException e) {
            throw new AWSException(e);
        }
    }

    public static void copyDir(File sourceFile, File targetFile) throws Exception {
        UtilFile.moveDir(sourceFile, targetFile, false);
    }

    public static void moveDir(File sourceFile, File targetFile) throws Exception {
        UtilFile.moveDir(sourceFile, targetFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveDir(File sourceFile, File targetFile, boolean isDeleteSource) throws Exception {
        if (!sourceFile.exists()) {
            throw new Exception("\u8def\u5f84\u4e0d\u5b58\u5728[" + sourceFile.getPath() + "]");
        }
        if (!sourceFile.isDirectory()) {
            return;
        }
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        Object object = _lock;
        synchronized (object) {
            File[] sourceFileList = sourceFile.listFiles();
            if (sourceFileList != null) {
                File[] fileArray = sourceFileList;
                int n = sourceFileList.length;
                int n2 = 0;
                while (n2 < n) {
                    File sourceSubFile = fileArray[n2];
                    if (sourceSubFile.isDirectory()) {
                        UtilFile.moveDir(sourceSubFile, new File(String.valueOf(targetFile.getPath()) + "/" + sourceSubFile.getName()), isDeleteSource);
                    } else {
                        UtilFile.moveFile(sourceSubFile, new File(String.valueOf(targetFile.getPath()) + "/" + sourceSubFile.getName()), isDeleteSource);
                    }
                    ++n2;
                }
            }
            if (isDeleteSource) {
                sourceFile.delete();
            }
        }
    }

    public static void copyFile(File sourceFile, File targetFile) throws Exception {
        UtilFile.moveFile(sourceFile, targetFile, false);
    }

    public static void moveFile(File sourceFile, File targetFile) throws Exception {
        UtilFile.moveFile(sourceFile, targetFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveFile(File sourceFile, File targetFile, boolean isDeleteSource) throws Exception {
        if (!sourceFile.exists()) {
            throw new Exception("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728[" + sourceFile.getPath() + "]");
        }
        int byteread = 0;
        FileInputStream inStream = null;
        FileOutputStream fs = null;
        Object object = _lock;
        synchronized (object) {
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            try {
                inStream = new FileInputStream(sourceFile);
                fs = new FileOutputStream(targetFile);
                byte[] buffer = new byte[1024];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    fs.write(buffer, 0, byteread);
                }
                fs.flush();
                FastFiles.removeFile(targetFile.getPath().replaceAll("\\\\", "/"));
            }
            finally {
                try {
                    if (inStream != null) {
                        ((InputStream)inStream).close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (fs != null) {
                        fs.close();
                    }
                }
                catch (Exception exception) {}
                if (isDeleteSource) {
                    sourceFile.delete();
                }
            }
        }
    }

    public static boolean removeFile(File file) {
        ArrayList<File> removeFailed = new ArrayList<File>();
        UtilFile.removeFile(file, removeFailed);
        return removeFailed.size() > 0;
    }

    public static void removeFile(File file, List<File> removeFailed) {
        File[] fs;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory() && (fs = file.listFiles()) != null) {
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                UtilFile.removeFile(f, removeFailed);
                ++n2;
            }
        }
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            if (file.exists()) {
                removeFailed.add(file);
            }
            System.err.println(e + "," + ExceptionUtil.getMessage(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipExpand(File zipFile, String dest) throws Exception {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory() || !DCUtil.isDangerFileName(zipFile.getName())) continue;
                throw new AWSIllegalArgumentException(String.valueOf(zipFile.getName()) + "\u542b\u6709\u975e\u6cd5\u6587\u4ef6");
            }
        }
        Object object = _zipLock;
        synchronized (object) {
            Expand expand = new Expand();
            Project prj = new Project();
            expand.setDest(new File(dest));
            expand.setProject(prj);
            expand.setEncoding("utf-8");
            expand.setSrc(zipFile);
            expand.setOverwrite(true);
            expand.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipCompress(String dir, File destZipFile) throws Exception {
        Object object = _zipLock;
        synchronized (object) {
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                return;
            }
            Zip zip = new Zip();
            Project prj = new Project();
            prj.setBaseDir(new File(dir));
            zip.setDestFile(destZipFile);
            FileSet fileSet = new FileSet();
            fileSet.setProject(prj);
            fileSet.setDir(new File(dir));
            zip.setProject(prj);
            zip.setEncoding("utf-8");
            zip.addFileset(fileSet);
            zip.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipCompress(String dir, File destZipFile, String fileName) throws Exception {
        Object object = _zipLock;
        synchronized (object) {
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                return;
            }
            Zip zip = new Zip();
            Project prj = new Project();
            prj.setBaseDir(dirFile);
            zip.setDestFile(destZipFile);
            FileSet fileSet = new FileSet();
            fileSet.setProject(prj);
            fileSet.setIncludes("**/*." + fileName);
            fileSet.setDir(dirFile);
            zip.setProject(prj);
            zip.setEncoding("utf-8");
            zip.addFileset(fileSet);
            zip.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipCompressExcludeName(String dir, File destZipFile, String fileExtName) throws Exception {
        Object object = _zipLock;
        synchronized (object) {
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                return;
            }
            Zip zip = new Zip();
            Project prj = new Project();
            prj.setBaseDir(dirFile);
            zip.setDestFile(destZipFile);
            FileSet fileSet = new FileSet();
            fileSet.setProject(prj);
            fileSet.setExcludes("**/*." + fileExtName);
            fileSet.setDir(dirFile);
            zip.setProject(prj);
            zip.setEncoding("utf-8");
            zip.addFileset(fileSet);
            zip.execute();
        }
    }

    public static String getFileSuffixIcon(String fn) {
        fn = fn.toLowerCase();
        String suffix = fn.substring(fn.lastIndexOf(".") + 1);
        String[] types = new String[]{"ai", "apk", "avi", "bmp", "chm", "css", "dmg", "doc", "exe", "file", "gif", "html", "icon", "ics", "ie", "ipa", "jpg", "js", "key", "mov", "mp3", "mp4", "mpg", "normal", "outlook", "pdf", "php", "png", "ppt", "psd", "rar", "torrent", "txt", "visio", "vsd", "xls", "xml", "zip"};
        List<String> single = Arrays.asList(types);
        if (single.contains(suffix)) {
            return "../commons/img/fileSuffix/" + suffix + ".png";
        }
        String[][] fix = new String[][]{{"word", "rtf", "docx", "wps"}, {"xls", "xlt", "xlw", "xlsx", "et"}, {"html", "htm"}, {"jpg", "pcx", "jpeg"}, {"ppt", "pot", "dps", "pps", "pptx", "potx", "ppsx"}, {"zip", "tar", "jar", "gz"}, {"txt", "logging", "ini"}, {"avi", "mpeg", "mpg", "ra", "rm", "rmvb", "mov", "qt", "asf", "wmv", "swf"}, {"access", "mdb", "accdb"}, {"xml", "xsd"}};
        int i = 0;
        while (i < fix.length) {
            List<String> fixitem = Arrays.asList(fix[i]);
            if (fixitem.contains(suffix)) {
                return "../commons/img/fileSuffix/" + fix[i][0] + ".png";
            }
            ++i;
        }
        return "../commons/img/fileSuffix/unknown.png";
    }

    public boolean isUTF8File() {
        String fileContent = this.readStr();
        if (fileContent == null) {
            return true;
        }
        return fileContent == null || Charset.forName("UTF-8").newEncoder().canEncode(fileContent);
    }

    public static void main(String[] args) throws Exception {
        UtilFile.zipCompress("e:/temp/abc", new File("e:/temp/abc.zip"));
        UtilFile.zipExpand(new File("e:/temp/abc.zip"), "e:/temp/aaa");
    }
}

