/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;

public final class UtilIO {
    public static final Charset UTF8_CHARSET = Charset.forName("utf-8");
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private UtilIO() {
    }

    private static String newStringFromBytes(byte[] bytes, int start, int length) {
        try {
            return new String(bytes, start, length, UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"utf-8\") returns invalid name.");
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return UtilIO.copy(input, output, 4096);
    }

    public static int copyAndCloseInput(InputStream input, OutputStream output) throws IOException {
        try {
            int n = UtilIO.copy(input, output, 4096);
            return n;
        }
        finally {
            input.close();
        }
    }

    public static int copyAndCloseInput(InputStream input, OutputStream output, int bufferSize) throws IOException {
        try {
            int n = UtilIO.copy(input, output, bufferSize);
            return n;
        }
        finally {
            input.close();
        }
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int avail = input.available();
        if (avail > 262144) {
            avail = 262144;
        }
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        return total;
    }

    public static void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        n = input.read(buffer);
        while (-1 != n) {
            output.write(buffer, 0, n);
            n = input.read(buffer);
        }
    }

    public static String toString(InputStream input) throws IOException {
        return UtilIO.toString(input, 4096);
    }

    public static String toString(InputStream input, int bufferSize) throws IOException {
        int avail = input.available();
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        StringBuilder buf = new StringBuilder();
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        n = input.read(buffer);
        while (-1 != n) {
            buf.append(UtilIO.newStringFromBytes(buffer, 0, n));
            n = input.read(buffer);
        }
        input.close();
        return buf.toString();
    }

    public static String toString(Reader input) throws IOException {
        StringBuilder buf = new StringBuilder();
        char[] buffer = new char[4096];
        int n = 0;
        n = input.read(buffer);
        while (-1 != n) {
            buf.append(new String(buffer, 0, n));
            n = input.read(buffer);
        }
        input.close();
        return buf.toString();
    }

    public static String readStringFromStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        int i = in.read();
        while (i != -1) {
            sb.append((char)i);
            i = in.read();
        }
        in.close();
        return sb.toString();
    }

    public static byte[] readBytesFromStream(InputStream in) throws IOException {
        int i = in.available();
        if (i < 4096) {
            i = 4096;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(i);
        UtilIO.copy(in, bos);
        in.close();
        return bos.toByteArray();
    }
}

