/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.util.AnimatedGifEncoder;
import com.actionsoft.bpms.util.GifDecoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;

public class UtilImage {
    public static void zoom(String srcFile, String outFile, float zoom) throws Exception {
        File oFile = new File(outFile);
        if (!oFile.exists()) {
            oFile.createNewFile();
        }
        UtilImage.zoom(srcFile, oFile, zoom);
    }

    public static void zoom(String srcFile, File outFile, float zoom) throws Exception {
        ImageIcon imgIcon = new ImageIcon(srcFile);
        Image img = imgIcon.getImage();
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int width = (int)((float)w * zoom);
        int height = (int)((float)h * zoom);
        UtilImage.zoom(srcFile, outFile, width, height);
    }

    public static void zoomW(String srcFile, String outFileName, int width) throws Exception {
        File outFile = new File(outFileName);
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        UtilImage.zoomW(srcFile, outFile, width);
    }

    public static void zoomW(String srcFile, File outFile, int width) throws Exception {
        ImageIcon imgIcon = new ImageIcon(srcFile);
        Image img = imgIcon.getImage();
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        if (w <= width) {
            width = w;
        }
        float zoom = (float)w / (float)width;
        int height = (int)((float)h / zoom);
        UtilImage.zoom(srcFile, outFile, width, height);
    }

    public static void zoomH(String srcFile, String outFileName, int height) throws Exception {
        File outFile = new File(outFileName);
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        UtilImage.zoomH(srcFile, outFile, height);
    }

    public static void zoomH(String srcFile, File outFile, int height) throws Exception {
        ImageIcon imgIcon = new ImageIcon(srcFile);
        Image img = imgIcon.getImage();
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        float zoom = (float)h / (float)height;
        int width = (int)((float)w / zoom);
        UtilImage.zoom(srcFile, outFile, width, height);
    }

    public static void zoom(String srcFile, File outFile, int width, int height) throws Exception {
        ImageIcon imgIcon = new ImageIcon(srcFile);
        Image srcImage = imgIcon.getImage();
        int w = srcImage.getWidth(null);
        int h = srcImage.getHeight(null);
        int destWidth = width;
        int destHeight = height;
        float zoom = (float)h / (float)height;
        if (w * height > h * width) {
            destWidth = (int)((float)w / zoom);
        } else {
            zoom = (float)w / (float)width;
            destHeight = (int)((float)h / zoom);
        }
        String formatName = UtilImage.getImageFormatName(new File(srcFile));
        if (formatName == null) {
            return;
        }
        formatName = formatName.toLowerCase();
        BufferedImage buffImg = null;
        if (IMAGE_FORMAT.GIF.getValue().equals(formatName)) {
            GifDecoder gd = new GifDecoder();
            FileInputStream fis = new FileInputStream(new File(srcFile));
            int status = gd.read(fis);
            if (status != 0) {
                throw new IOException("read image " + srcFile + " error!");
            }
            AnimatedGifEncoder ge = new AnimatedGifEncoder();
            FileOutputStream outStrem = new FileOutputStream(outFile);
            ge.start(outStrem);
            ge.setRepeat(0);
            int i = 0;
            while (i < gd.getFrameCount()) {
                BufferedImage frame = gd.getFrame(i);
                BufferedImage rescaled = UtilImage.resize(frame, destWidth, destHeight);
                int delay = gd.getDelay(i);
                ge.setDelay(delay);
                ge.addFrame(rescaled);
                ++i;
            }
            ge.finish();
            outStrem.flush();
        } else {
            buffImg = UtilImage.resize(srcImage, destWidth, destHeight);
            ImageIO.write((RenderedImage)buffImg, IMAGE_FORMAT.JPG.getValue(), outFile);
            buffImg.flush();
        }
        srcImage.flush();
    }

    public static void zoomCut(String srcFileName, String outFileName, int width, int height) throws Exception {
        File outFile = new File(outFileName);
        UtilImage.zoomCut(srcFileName, outFile, width, height);
    }

    public static void zoomCut(String srcFile, File outFile, int width, int height) throws Exception {
        ImageIcon imgIcon = new ImageIcon(srcFile);
        Image srcImage = imgIcon.getImage();
        int w = srcImage.getWidth(null);
        int h = srcImage.getHeight(null);
        int destWidth = width;
        int destHeight = height;
        int x = 0;
        int y = 0;
        float zoom = (float)h / (float)height;
        if (w * height > h * width) {
            destWidth = (int)((float)w / zoom);
            x = (destWidth - width) / 2;
        } else {
            zoom = (float)w / (float)width;
            destHeight = (int)((float)h / zoom);
            y = (destHeight - height) / 2;
        }
        String formatName = UtilImage.getImageFormatName(new File(srcFile));
        if (formatName == null) {
            return;
        }
        formatName = formatName.toLowerCase();
        BufferedImage buffImg = null;
        if (IMAGE_FORMAT.GIF.getValue().equals(formatName)) {
            GifDecoder gd = new GifDecoder();
            int status = gd.read(srcFile);
            if (status != 0) {
                throw new IOException("read image " + srcFile + " error!");
            }
            AnimatedGifEncoder ge = new AnimatedGifEncoder();
            FileOutputStream outStrem = new FileOutputStream(outFile);
            ge.start(outStrem);
            ge.setRepeat(0);
            int i = 0;
            while (i < gd.getFrameCount()) {
                BufferedImage frame = gd.getFrame(i);
                BufferedImage rescaled = UtilImage.resizeCut(frame, destWidth, destHeight, x, y, width, height);
                int delay = gd.getDelay(i);
                ge.setDelay(delay);
                ge.addFrame(rescaled);
                ++i;
            }
            ge.finish();
            outStrem.flush();
        } else {
            buffImg = UtilImage.resizeCut(srcImage, destWidth, destHeight, x, y, width, height);
            ImageIO.write((RenderedImage)buffImg, IMAGE_FORMAT.JPG.getValue(), outFile);
            buffImg.flush();
        }
        srcImage.flush();
    }

    public static BufferedImage resize(Image image, int width, int height) {
        BufferedImage buffImg = new BufferedImage(width, height, 1);
        Graphics2D g = buffImg.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return buffImg;
    }

    public static BufferedImage resizeCut(Image image, int zoomWidth, int zoomHeight, int x, int y, int width, int height) {
        BufferedImage buffImg = new BufferedImage(zoomWidth, zoomHeight, 1);
        Graphics2D g = buffImg.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, zoomWidth, zoomHeight);
        g.drawImage(image, 0, 0, zoomWidth, zoomHeight, null);
        g.dispose();
        image.flush();
        CropImageFilter cropFilter = new CropImageFilter(x, y, width, height);
        Image img = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(buffImg.getSource(), cropFilter));
        BufferedImage tag = new BufferedImage(width, height, 1);
        Graphics g2 = tag.getGraphics();
        g2.drawImage(img, 0, 0, width, height, null);
        g2.dispose();
        img.flush();
        buffImg.flush();
        image.flush();
        return tag;
    }

    public static String getImageFormatName(File file) throws IOException {
        String formatName = null;
        ImageInputStream iis = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> imageReader = ImageIO.getImageReaders(iis);
        if (imageReader.hasNext()) {
            ImageReader reader = imageReader.next();
            formatName = reader.getFormatName();
        }
        return formatName;
    }

    public static enum IMAGE_FORMAT {
        BMP("bmp"),
        JPG("jpg"),
        WBMP("wbmp"),
        JPEG("jpeg"),
        PNG("png"),
        GIF("gif");

        private String value;

        private IMAGE_FORMAT(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

