/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UtilJson {
    private static String BR = "<brbrbrbrbrbrbr>";

    public static List<Map<String, Object>> parseJSON2List(String jsonStr) {
        JSONArray jsonArr = JSONArray.parseArray((String)jsonStr);
        return UtilJson.array2List(jsonArr);
    }

    private static List<Map<String, Object>> array2List(JSONArray jsonArr) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int len = jsonArr.size();
        int i = 0;
        while (i < len) {
            list.add((Map<String, Object>)jsonArr.getJSONObject(i));
            ++i;
        }
        return list;
    }

    public static Map<String, Object> parseJSON2Map(String jsonStr) {
        jsonStr = jsonStr.replaceAll("\r\n", BR);
        jsonStr = jsonStr.replaceAll("\n", BR);
        jsonStr = jsonStr.replaceAll("\r", BR);
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject json = JSONObject.parseObject((String)jsonStr);
        for (Object k : json.keySet()) {
            Object v = json.get(k);
            if (v instanceof JSONArray) {
                map.put(k.toString(), UtilJson.array2List((JSONArray)v));
                continue;
            }
            if (v instanceof String) {
                String vString = (String)v;
                vString = vString.replaceAll(BR, "\n");
                v = vString;
            }
            map.put(k.toString(), v);
        }
        return map;
    }

    public static List<Map<String, Object>> getListByUrl(String url) {
        return UtilJson.getListByUrl(url, "utf-8");
    }

    public static List<Map<String, Object>> getListByUrl(String url, String charsetName) {
        InputStream in = null;
        BufferedReader reader = null;
        try {
            String line;
            in = new URL(url).openStream();
            reader = new BufferedReader(new InputStreamReader(in, charsetName));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            List<Map<String, Object>> list = UtilJson.parseJSON2List(sb.toString());
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static Map<String, Object> getMapByUrl(String url) {
        return UtilJson.getMapByUrl(url, "utf-8");
    }

    public static Map<String, Object> getMapByUrl(String url, String charsetName) {
        InputStream in = null;
        BufferedReader reader = null;
        try {
            String line;
            in = new URL(url).openStream();
            reader = new BufferedReader(new InputStreamReader(in, charsetName));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            if (UtilString.isEmpty(sb.toString())) {
                return null;
            }
            Map<String, Object> map = UtilJson.parseJSON2Map(sb.toString());
            return map;
        }
        catch (Exception e) {
            throw new AWSException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Integer optInteger(JSONObject jsonObject, String key, Integer defaultVal) {
        Integer val = jsonObject.getInteger(key);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public static boolean optBoolean(JSONObject jsonObject, String key, boolean defaultVal) {
        Boolean val = jsonObject.getBoolean(key);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public static double optDouble(JSONObject jsonObject, String key, double defaultVal) {
        Double val = jsonObject.getDouble(key);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public static Integer optInt(JSONObject jsonObject, String key, Integer defaultVal) {
        Integer val = jsonObject.getInteger(key);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public static String optString(JSONObject jsonObject, String key) {
        return UtilJson.optString(jsonObject, key, "");
    }

    public static String optString(JSONObject jsonObject, String key, String defaultVal) {
        if (jsonObject == null) {
            return defaultVal;
        }
        String val = jsonObject.getString(key);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    public static JSONObject parseObject(Map map) {
        return JSON.parseObject((String)JSON.toJSONString((Object)map));
    }

    public static JSONArray parseArray(List list) {
        return JSON.parseArray((String)JSON.toJSONString((Object)list));
    }

    public static JSONArray parseArray(Object[] objectArray) {
        return JSON.parseArray((String)JSON.toJSONString((Object)objectArray));
    }

    public static boolean mayBeJSON(String string) {
        return string != null && ("null".equals(string) || string.startsWith("[") && string.endsWith("]") || string.startsWith("{") && string.endsWith("}"));
    }
}

