/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class UtilListSort<E> {
    public void sortAsc(List<E> list, String field) {
        this.sort(list, field, "asc");
    }

    public void sortDesc(List<E> list, String field) {
        this.sort(list, field, "desc");
    }

    public void sort(List<E> list, final String field, final String sort) {
        Collections.sort(list, new Comparator<E>(){

            @Override
            public int compare(Object a, Object b) {
                int ret = 0;
                try {
                    Method method = a.getClass().getMethod("get" + UtilListSort.this.toFirstUpperCase(field), new Class[0]);
                    if (Date.class.getName().equals(method.getReturnType().getName())) {
                        Date dateA = (Date)method.invoke(a, new Object[0]);
                        Date dateB = (Date)method.invoke(b, new Object[0]);
                        ret = sort != null && "desc".equals(sort.toLowerCase()) ? dateB.compareTo(dateA) : dateA.compareTo(dateB);
                    } else if (java.sql.Date.class.getName().equals(method.getReturnType().getName())) {
                        java.sql.Date dateA = (java.sql.Date)method.invoke(a, new Object[0]);
                        java.sql.Date dateB = (java.sql.Date)method.invoke(b, new Object[0]);
                        ret = sort != null && "desc".equals(sort.toLowerCase()) ? dateB.compareTo(dateA) : dateA.compareTo(dateB);
                    } else if (Timestamp.class.getName().equals(method.getReturnType().getName())) {
                        Timestamp dateA = (Timestamp)method.invoke(a, new Object[0]);
                        Timestamp dateB = (Timestamp)method.invoke(b, new Object[0]);
                        if (sort != null && "desc".equals(sort.toLowerCase())) {
                            if (dateB != null && dateA != null) {
                                ret = dateB.compareTo(dateA);
                            }
                        } else {
                            ret = dateA.compareTo(dateB);
                        }
                    } else {
                        String strA = String.valueOf(method.invoke(a, new Object[0]));
                        String strB = String.valueOf(method.invoke(b, new Object[0]));
                        Collator collatorChinese = Collator.getInstance(Locale.CHINA);
                        ret = sort != null && "desc".equals(sort.toLowerCase()) ? collatorChinese.compare(strB, strA) : collatorChinese.compare(strA, strB);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return ret;
            }
        });
    }

    private String toFirstUpperCase(String str) {
        return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
    }
}

