/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.util.UtilString;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class UtilNumber {
    private static String[] HanDigiStr = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static String[] HanDiviStr = new String[]{"", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf"};
    private static final int DEF_DIV_SCALE = 10;

    public static double fixPoint(double num, int pointNumber) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(pointNumber);
        String f = format.format(num);
        f = new UtilString(f).replace(",", "");
        return Double.parseDouble(f);
    }

    public static String fixPoint(String num, int pointNumber) {
        return UtilNumber.doFixPoint(num, pointNumber, false);
    }

    public static String fixPointForce(String num, int pointNumber) {
        return UtilNumber.doFixPoint(num, pointNumber, true);
    }

    public static String doFixPoint(String num, int pointNumber, boolean isForce) {
        if (num != null) {
            num = num.trim();
        }
        if (num != null && num.trim().length() > 0 && (isForce || num.indexOf(".") != -1)) {
            if (pointNumber < 0) {
                throw new IllegalArgumentException("The scale must be a positive integer or zero");
            }
            BigDecimal b = new BigDecimal(num);
            BigDecimal one = new BigDecimal("1");
            BigDecimal b3 = b.divide(one, pointNumber, 4);
            String tmp = b3.toPlainString();
            return tmp;
        }
        return num;
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static String add(String v1, String v2) {
        if (v1 != null && v1.equals("")) {
            v1 = "0";
        }
        if (v2 != null && v2.equals("")) {
            v2 = "0";
        }
        if (v1 != null && v1.trim().length() > 0 && v2 != null && v2.trim().length() > 0) {
            BigDecimal b1 = new BigDecimal(v1.trim());
            BigDecimal b2 = new BigDecimal(v2.trim());
            BigDecimal b3 = b1.add(b2);
            return b3.toPlainString();
        }
        return v1;
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static String sub(String v1, String v2) {
        if (v1 != null && v1.trim().length() > 0 && v2 != null && v2.trim().length() > 0) {
            BigDecimal b1 = new BigDecimal(v1.trim());
            BigDecimal b2 = new BigDecimal(v2.trim());
            BigDecimal b3 = b1.subtract(b2);
            return b3.toPlainString();
        }
        return v1;
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static String mul(String v1, String v2) {
        if (v1 != null && v1.trim().length() > 0 && v2 != null && v2.trim().length() > 0) {
            BigDecimal b1 = new BigDecimal(v1.trim());
            BigDecimal b2 = new BigDecimal(v2.trim());
            BigDecimal b3 = b1.multiply(b2);
            return b3.toPlainString();
        }
        return v1;
    }

    public static double div(double v1, double v2) {
        return UtilNumber.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static String div(String v1, String v2, int scale) {
        BigDecimal b1 = new BigDecimal(v1.trim());
        BigDecimal b2 = new BigDecimal(v2.trim());
        BigDecimal b3 = b1.divide(b2, scale, 4);
        return b3.toPlainString();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static String round(String v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(v.trim());
        BigDecimal one = new BigDecimal("1");
        BigDecimal b3 = b.divide(one, scale, 4);
        return b3.toPlainString();
    }

    public static String toFixMoney(String num, int digit) {
        String fmstr = "###,##0";
        int i = 0;
        while (i < digit) {
            fmstr = i != 0 ? String.valueOf(fmstr) + "0" : String.valueOf(fmstr) + ".0";
            ++i;
        }
        DecimalFormat df = new DecimalFormat(fmstr);
        num = df.format(Double.parseDouble(num.trim()));
        return num;
    }

    public static String toFixMoney(double num, int digit) {
        String fmstr = "###,##0";
        int i = 0;
        while (i < digit) {
            fmstr = i != 0 ? String.valueOf(fmstr) + "0" : String.valueOf(fmstr) + ".0";
            ++i;
        }
        DecimalFormat df = new DecimalFormat(fmstr);
        return df.format(num);
    }

    public static String getMoneyTypeNumber(String number) {
        if (number == null || number.trim().length() == 0) {
            return number;
        }
        DecimalFormat currencyFormat = new DecimalFormat();
        double number2 = Double.parseDouble(number.trim());
        String value = currencyFormat.format(number2);
        return value;
    }

    public static String toRMB(String numStr) {
        String RMBStr = "";
        boolean lastZero = false;
        boolean hasValue = false;
        boolean blZero = false;
        int len = (numStr = numStr.trim()).length();
        if (len > 15) {
            return "\u6570\u503c\u8fc7\u5927!";
        }
        int i = len - 1;
        while (i >= 0) {
            if (numStr.charAt(len - i - 1) != ' ') {
                int n = numStr.charAt(len - i - 1) - 48;
                if (n < 0 || n > 9) {
                    return "\u8f93\u5165\u542b\u975e\u6570\u5b57\u5b57\u7b26!";
                }
                if (n != 0) {
                    if (lastZero) {
                        RMBStr = String.valueOf(RMBStr) + HanDigiStr[0];
                    }
                    if (i % 4 == 3 && blZero) {
                        RMBStr = String.valueOf(RMBStr) + HanDigiStr[0];
                    }
                    RMBStr = String.valueOf(RMBStr) + HanDigiStr[n];
                    RMBStr = String.valueOf(RMBStr) + HanDiviStr[i];
                    hasValue = true;
                } else if (i % 8 == 0 || i % 8 == 4 && hasValue) {
                    RMBStr = String.valueOf(RMBStr) + HanDiviStr[i];
                }
                if (i % 8 == 0) {
                    hasValue = false;
                }
                lastZero = n == 0 && i % 4 != 0;
                blZero = n == 0 && i % 4 == 0;
            }
            --i;
        }
        if (RMBStr.length() == 0) {
            return HanDigiStr[0];
        }
        return RMBStr;
    }

    public static String toRMB(double num) {
        String SignStr = "";
        String TailStr = "";
        if (num < 0.0) {
            num = -num;
            SignStr = "\u8d1f";
        }
        if (num > 1.0E14 || num < -1.0E14) {
            return "\u6570\u503c\u4f4d\u6570\u8fc7\u5927!";
        }
        long temp = Math.round(num * 100.0);
        long integer = temp / 100L;
        long fraction = temp % 100L;
        int jiao = (int)fraction / 10;
        int fen = (int)fraction % 10;
        String tempStr = String.valueOf(integer);
        int yuan = tempStr.charAt(tempStr.length() - 1) - 48;
        if (jiao == 0 && fen == 0) {
            TailStr = "\u6574";
        }
        if (jiao != 0 && fen == 0) {
            TailStr = yuan == 0 ? "\u96f6" + HanDigiStr[jiao] + "\u89d2\u6574" : String.valueOf(HanDigiStr[jiao]) + "\u89d2\u6574";
        }
        if (jiao == 0 && fen != 0) {
            TailStr = "\u96f6" + HanDigiStr[fen] + "\u5206";
        }
        if (jiao != 0 && fen != 0) {
            TailStr = yuan == 0 ? "\u96f6" + HanDigiStr[jiao] + "\u89d2" + HanDigiStr[fen] + "\u5206" : String.valueOf(HanDigiStr[jiao]) + "\u89d2" + HanDigiStr[fen] + "\u5206";
        }
        return String.valueOf(SignStr) + UtilNumber.toRMB(String.valueOf(integer)) + "\u5143" + TailStr;
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

