/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.bpms.util.UtilDate;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Date;
import javax.imageio.ImageIO;
import org.icepdf.core.pobjects.Document;

public class UtilPdf {
    public static final String FILETYPE_JPG = "jpg";
    public static final String SUFF_IMAGE = ".jpg";
    public static final int WIDTH = 50;
    public static final int HEIGHT = 50;

    public static File pdf2Jpg(String inputFile, String outputFile) throws Exception {
        File outFile = new File(outputFile);
        return UtilPdf.pdf2Jpg(inputFile, outFile);
    }

    public static File pdf2Jpg(String inputFile, String outputFile, float zoom) throws Exception {
        File outFile = new File(outputFile);
        return UtilPdf.pdf2Jpg(inputFile, outFile, zoom);
    }

    public static File pdf2Jpg(String inputFile, File outputFile) throws Exception {
        return UtilPdf.pdf2Jpg(inputFile, outputFile, 1.0f);
    }

    public static File pdf2Jpg(String inputFile, File outputFile, float zoom) throws Exception {
        Document document = null;
        float rotation = 0.0f;
        document = new Document();
        document.setFile(inputFile);
        int maxPages = document.getPageTree().getNumberOfPages();
        if (maxPages > 1) {
            BufferedImage img = (BufferedImage)document.getPageImage(0, 1, 2, rotation, zoom);
            ImageIO.write((RenderedImage)img, FILETYPE_JPG, outputFile);
            System.out.println("PDF\u6587\u4ef6\u8f6c\u6362JPG\u6587\u4ef6\u6210\u529f");
            return outputFile;
        }
        return null;
    }

    public static void pdf2JpgAll(String inputFile, String outputFile, float zoom) throws Exception {
        File oFile = new File(outputFile);
        if (!oFile.exists()) {
            oFile.mkdir();
        }
        Document document = null;
        float rotation = 0.0f;
        document = new Document();
        document.setFile(inputFile);
        int maxPages = document.getPageTree().getNumberOfPages();
        int i = 0;
        while (i < maxPages) {
            BufferedImage img = (BufferedImage)document.getPageImage(i, 1, 2, rotation, zoom);
            File outFile = new File(String.valueOf(outputFile) + (i + 1) + SUFF_IMAGE);
            ImageIO.write((RenderedImage)img, FILETYPE_JPG, outFile);
            ++i;
        }
        System.out.println("[" + UtilDate.datetimeFormat(new Date()) + "] PDF\u6587\u4ef6\u8f6c\u6362JPG\u6587\u4ef6\u6210\u529f");
    }

    public static BufferedImage pdf2Image(String inputFile) throws Exception {
        Document document = null;
        float rotation = 0.0f;
        document = new Document();
        document.setFile(inputFile);
        int maxPages = document.getPageTree().getNumberOfPages();
        if (maxPages > 1) {
            BufferedImage img = (BufferedImage)document.getPageImage(0, 1, 2, rotation, 1.0f);
            return img;
        }
        return null;
    }

    public static File pdf2JpgZoom(String inputFile, String outputFile, float width) throws Exception {
        File oFile = new File(outputFile);
        if (!oFile.exists()) {
            oFile.mkdir();
        }
        Document document = null;
        float rotation = 0.0f;
        document = new Document();
        document.setFile(inputFile);
        int maxPages = document.getPageTree().getNumberOfPages();
        if (maxPages > 1) {
            BufferedImage img = (BufferedImage)document.getPageImage(0, 1, 2, rotation, 1.0f);
            int w = img.getWidth();
            float zoom = width / (float)w;
            img = (BufferedImage)document.getPageImage(0, 1, 2, rotation, zoom);
            ImageIO.write((RenderedImage)img, FILETYPE_JPG, oFile);
            System.out.println("[" + UtilDate.datetimeFormat(new Date()) + "] PDF\u6587\u4ef6\u8f6c\u6362JPG\u6587\u4ef6\u6210\u529f");
            return oFile;
        }
        return null;
    }

    public static File pdf2JpgZoomHeight(String inputFile, String outputFile, float height) throws Exception {
        File oFile = new File(outputFile);
        if (!oFile.exists()) {
            oFile.mkdir();
        }
        return UtilPdf.pdf2JpgZoomHeight(inputFile, oFile, height);
    }

    public static File pdf2JpgZoomHeight(String inputFile, File outputFile, float height) throws Exception {
        Document document = null;
        float rotation = 0.0f;
        document = new Document();
        document.setFile(inputFile);
        int maxPages = document.getPageTree().getNumberOfPages();
        if (maxPages > 1) {
            BufferedImage img = (BufferedImage)document.getPageImage(0, 1, 2, rotation, 1.0f);
            int h = img.getHeight();
            float zoom = height / (float)h;
            img = (BufferedImage)document.getPageImage(0, 1, 2, rotation, zoom);
            ImageIO.write((RenderedImage)img, FILETYPE_JPG, outputFile);
            System.out.println("[" + UtilDate.datetimeFormat(new Date()) + "] PDF\u6587\u4ef6\u8f6c\u6362JPG\u6587\u4ef6\u6210\u529f");
            return outputFile;
        }
        return null;
    }

    public static void main(String[] args) {
        String sourceFile = "/home/wsz/SVN\u96c6\u6210.pdf";
        String targetFile = "/home/wsz/SVN\u96c6\u6210.jpg";
        try {
            UtilPdf.pdf2JpgZoomHeight(sourceFile, targetFile, 100.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

