/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jodd.util.StringUtil;
import org.apache.commons.lang.StringUtils;

public final class UtilString {
    private String strSuper;
    private static Map<String, Map<String, String>> priorityMap = new HashMap<String, Map<String, String>>();

    static {
        HashMap<String, String> subMap = new HashMap<String, String>();
        subMap.put("+", ">");
        subMap.put("-", ">");
        subMap.put("*", "<");
        subMap.put("/", "<");
        subMap.put("(", "<");
        subMap.put(")", ">");
        subMap.put("#", ">");
        priorityMap.put("+", subMap);
        subMap = new HashMap();
        subMap.put("+", ">");
        subMap.put("-", ">");
        subMap.put("*", "<");
        subMap.put("/", "<");
        subMap.put("(", "<");
        subMap.put(")", ">");
        subMap.put("#", ">");
        priorityMap.put("-", subMap);
        subMap = new HashMap();
        subMap.put("+", ">");
        subMap.put("-", ">");
        subMap.put("*", ">");
        subMap.put("/", ">");
        subMap.put("(", "<");
        subMap.put(")", ">");
        subMap.put("#", ">");
        priorityMap.put("*", subMap);
        subMap = new HashMap();
        subMap.put("+", ">");
        subMap.put("-", ">");
        subMap.put("*", ">");
        subMap.put("/", ">");
        subMap.put("(", "<");
        subMap.put(")", ">");
        subMap.put("#", ">");
        priorityMap.put("/", subMap);
        subMap = new HashMap();
        subMap.put("+", "<");
        subMap.put("-", "<");
        subMap.put("*", "<");
        subMap.put("/", "<");
        subMap.put("(", "<");
        subMap.put(")", "=");
        priorityMap.put("(", subMap);
        subMap = new HashMap();
        subMap.put("+", ">");
        subMap.put("-", ">");
        subMap.put("*", ">");
        subMap.put("/", ">");
        subMap.put(")", ">");
        subMap.put("#", ">");
        priorityMap.put(")", subMap);
        subMap = new HashMap();
        subMap.put("+", "<");
        subMap.put("-", "<");
        subMap.put("*", "<");
        subMap.put("/", "<");
        subMap.put("(", "<");
        subMap.put("#", "=");
        priorityMap.put("#", subMap);
    }

    public UtilString() {
        this.strSuper = new String();
    }

    public UtilString(String str) {
        this.strSuper = UtilString.getStringFromEmpty(str);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        return UtilString.isEmpty(obj.toString());
    }

    public static boolean isEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static String join(Collection<?> collection, String separator) {
        return StringUtils.join(collection, (String)separator);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmptyByTrim(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmptyNotTrim(String str) {
        return str == null || str.length() == 0;
    }

    public static String getStringFromEmpty(String str) {
        if (str != null) {
            return str;
        }
        return "";
    }

    public static String getEncodingName(String str) {
        String[] guest;
        if (str == null) {
            return "";
        }
        String[] stringArray = guest = new String[]{"UTF-8", "GB2312", "GB18030", "GBK", "ISO-8859-1", "Big5", "Big5-HKSCS", "US-ASCII"};
        int n = guest.length;
        int n2 = 0;
        while (n2 < n) {
            String encode = stringArray[n2];
            try {
                if (Charset.forName(encode).newEncoder().canEncode(str)) {
                    return encode;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return "";
    }

    public List<String> split(String strSign) {
        if (!strSign.startsWith("\\")) {
            strSign = "\\" + strSign;
        }
        String[] args = this.strSuper.split(strSign);
        ArrayList<String> list = new ArrayList<String>(args.length);
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                list.add(arg);
                ++n2;
            }
        }
        return list;
    }

    public String matchValue(String strBegin, String strEnd) {
        return this.matchValue(strBegin, strEnd, false);
    }

    public String matchValue(String strBegin, String strEnd, boolean ignoreCase) {
        String str = this.strSuper;
        String result = "";
        if (ignoreCase) {
            str = str.toLowerCase();
            strBegin = strBegin.toLowerCase();
            strEnd = strEnd.toLowerCase();
        }
        int begin = str.indexOf(strBegin);
        int end = str.lastIndexOf(strEnd);
        if (begin > -1 && end > -1 && end > begin) {
            result = this.strSuper.substring(begin + strBegin.length(), end);
        }
        return result;
    }

    public String replace(String strOld, String strNew) {
        if (strOld == null || strOld.equals("")) {
            return this.strSuper;
        }
        return this.strSuper.replace(strOld, strNew);
    }

    public static String cutString(String str, int length) {
        if (str == null) {
            return "";
        }
        if (str.length() > length && length > 2) {
            return String.valueOf(str.substring(0, length)) + ".";
        }
        return str;
    }

    public String toString() {
        return this.strSuper;
    }

    public static double analysisStrFormula(String exp) {
        ArrayList<String> tokens = new ArrayList<String>();
        int posb = 0;
        int pose = 0;
        int i = 0;
        while (i < exp.length()) {
            String current = String.valueOf(exp.charAt(i));
            if (i == exp.length() - 1 && !priorityMap.containsKey(current)) {
                pose = i;
                tokens.add(exp.substring(posb, pose + 1).trim());
            }
            if (priorityMap.containsKey(current)) {
                pose = i - 1;
                String num = exp.substring(posb, pose + 1).trim();
                if (StringUtil.isNotEmpty((CharSequence)num)) {
                    tokens.add(num);
                }
                tokens.add(current);
                posb = i + 1;
            }
            ++i;
        }
        tokens.add("#");
        LinkedList<String> optStack = new LinkedList<String>();
        LinkedList<Double> numStack = new LinkedList<Double>();
        optStack.add("#");
        for (String token : tokens) {
            UtilString.process(token, optStack, numStack);
        }
        return (Double)numStack.pop();
    }

    private static void process(String token, LinkedList<String> optStack, LinkedList<Double> numStack) {
        while (!"#".equals(optStack.getFirst()) || !token.equals("#")) {
            if (UtilString.isNumber(token)) {
                numStack.push(Double.parseDouble(token));
                break;
            }
            String priority = UtilString.priority(optStack.getFirst(), token);
            if ("<".equals(priority)) {
                optStack.push(token);
                break;
            }
            if ("=".equals(priority)) {
                optStack.pop();
                break;
            }
            double res = UtilString.calculate(optStack.pop(), numStack.pop(), numStack.pop());
            numStack.push(res);
        }
    }

    private static double calculate(String opt, double n1, double n2) {
        if ("+".equals(opt)) {
            return n2 + n1;
        }
        if ("-".equals(opt)) {
            return n2 - n1;
        }
        if ("*".equals(opt)) {
            return n2 * n1;
        }
        if ("/".equals(opt) && n1 != 0.0) {
            return n2 / n1;
        }
        return 0.0;
    }

    private static boolean isNumber(String token) {
        int LEN = token.length();
        int ix = 0;
        while (ix < LEN) {
            char ch = token.charAt(ix);
            if (!(ch == '.' || ch == '-' && LEN > 1 || ch >= '0' && ch <= '9')) {
                return false;
            }
            ++ix;
        }
        return true;
    }

    public static String priority(String op1, String op2) {
        return priorityMap.get(op1).get(op2);
    }
}

