/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.util;

import com.actionsoft.exception.AWSException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.http.client.fluent.Request;

public class UtilURL {
    public static String URLEncode(String str) {
        if (str == null) {
            return str;
        }
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception e) {
            return str;
        }
    }

    public static String URLDecode(String str) {
        if (str == null) {
            return str;
        }
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (Exception e) {
            return str;
        }
    }

    public static byte[] getBytes(String url) {
        try {
            return Request.Get((String)url).execute().returnContent().asBytes();
        }
        catch (Exception e) {
            throw new AWSException(e);
        }
    }

    public static String get(String url) {
        return UtilURL.post(url, null);
    }

    public static String get(String url, String charset) {
        return UtilURL.post(url, null, charset);
    }

    public static String post(String url, Map<String, String> param) {
        return UtilURL.post(url, param, null);
    }

    public static String post(String url, Map<String, String> param, String outCharset) {
        block16: {
            if (outCharset == null) {
                outCharset = "UTF-8";
            }
            HttpURLConnection conn = null;
            try {
                URL u = new URL(url);
                conn = (HttpURLConnection)u.openConnection();
                conn.setRequestProperty("User-agent", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/29.0.1547.66 Safari/537.36");
                StringBuilder sb = null;
                if (param != null) {
                    sb = new StringBuilder();
                    conn.setRequestMethod("POST");
                    conn.setDoOutput(true);
                    OutputStream out = conn.getOutputStream();
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
                    if (param != null && !param.isEmpty()) {
                        for (Map.Entry<String, String> s : param.entrySet()) {
                            sb.append(s.getKey()).append("=").append(s.getValue()).append("&");
                        }
                        writer.write(sb.deleteCharAt(sb.toString().length() - 1).toString());
                    }
                    writer.close();
                    sb = null;
                }
                conn.connect();
                sb = new StringBuilder();
                int recode = conn.getResponseCode();
                BufferedReader reader = null;
                if (recode != 200) break block16;
                InputStream in = conn.getInputStream();
                String encoding = conn.getContentEncoding();
                if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
                    GZIPInputStream gis = new GZIPInputStream(in);
                    reader = new BufferedReader(new InputStreamReader((InputStream)gis, outCharset));
                    String str = reader.readLine();
                    while (str != null) {
                        sb.append(str).append(System.getProperty("line.separator"));
                        str = reader.readLine();
                    }
                } else {
                    reader = new BufferedReader(new InputStreamReader(in, outCharset));
                    String str = reader.readLine();
                    while (str != null) {
                        sb.append(str).append(System.getProperty("line.separator"));
                        str = reader.readLine();
                    }
                }
                reader.close();
                if (sb.toString().length() == 0) {
                    return null;
                }
                String string = sb.toString().substring(0, sb.toString().length() - System.getProperty("line.separator").length());
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return null;
    }
}

