/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.exception;

import com.actionsoft.exception.AWSException;
import com.actionsoft.i18n.I18nRes;

public class AWSIllegalArgumentException
extends AWSException {
    public static final String NULL = "NULL";
    public static final String EMPT = "EMPT";
    public static final String FORMAT = "FORMAT";
    private static final long serialVersionUID = 1L;
    private String argumentName;
    private String illegalType;

    public AWSIllegalArgumentException(String message) {
        super(message);
    }

    public AWSIllegalArgumentException(String message, Throwable cause) {
        super(message, cause);
    }

    public AWSIllegalArgumentException(String argumentName, String illegalType) {
        super(AWSIllegalArgumentException.formatMsg(argumentName, illegalType, ""));
        this.argumentName = argumentName;
        this.illegalType = illegalType;
    }

    public AWSIllegalArgumentException(String argumentName, String illegalType, String message) {
        super(AWSIllegalArgumentException.formatMsg(argumentName, illegalType, message));
        this.argumentName = argumentName;
        this.illegalType = illegalType;
    }

    public AWSIllegalArgumentException(String argumentName, String illegalType, Throwable cause) {
        super(AWSIllegalArgumentException.formatMsg(argumentName, illegalType, ""), cause);
        this.argumentName = argumentName;
        this.illegalType = illegalType;
    }

    public AWSIllegalArgumentException(String argumentName, String illegalType, String message, Throwable cause) {
        super(AWSIllegalArgumentException.formatMsg(argumentName, illegalType, message), cause);
        this.argumentName = argumentName;
        this.illegalType = illegalType;
    }

    private static String formatMsg(String argumentName, String illegalType, String message) {
        if (illegalType.equalsIgnoreCase(NULL)) {
            return String.valueOf(I18nRes.findValue("_bpm.platform", "\u53c2\u6570")) + "[" + argumentName + "]" + I18nRes.findValue("_bpm.platform", "\u4e0d\u5141\u8bb8\u4e3a\u7a7a") + message;
        }
        if (illegalType.equalsIgnoreCase(EMPT)) {
            return String.valueOf(I18nRes.findValue("_bpm.platform", "\u53c2\u6570")) + "[" + argumentName + "]" + I18nRes.findValue("_bpm.platform", "\u662f\u5fc5\u987b\u7684") + message;
        }
        if (illegalType.equalsIgnoreCase(FORMAT)) {
            return String.valueOf(I18nRes.findValue("_bpm.platform", "\u53c2\u6570")) + "[" + argumentName + "]" + I18nRes.findValue("_bpm.platform", "\u503c\u975e\u6cd5") + message;
        }
        StringBuilder sb = new StringBuilder();
        if (argumentName != null && argumentName.length() > 0) {
            sb.append(String.valueOf(I18nRes.findValue("_bpm.platform", "\u53c2\u6570")) + "[" + argumentName + "]");
        }
        if (illegalType != null) {
            sb.append(illegalType);
        }
        if (sb.length() > 0) {
            sb.append("\u3002");
        }
        if (message != null) {
            sb.append(message);
        }
        return sb.toString();
    }

    @Override
    public String getAPIErrorCode() {
        return "400";
    }

    public String getArgumentName() {
        return this.argumentName;
    }

    public String getIllegalType() {
        return this.illegalType.toUpperCase();
    }
}

