/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.exception;

import com.actionsoft.bpms.util.UtilString;
import java.lang.reflect.InvocationTargetException;

public class ExceptionUtil {
    public static String getMessage(Throwable t) {
        return ExceptionUtil.getMsg(t);
    }

    private static String getMsg(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ExceptionUtil.getMsg(((InvocationTargetException)t).getTargetException());
        }
        if (t instanceof NullPointerException) {
            StackTraceElement[] sts = t.getStackTrace();
            if (sts != null && sts.length > 0) {
                return t + "\nCaused by: " + sts[0];
            }
            return t.toString();
        }
        if (t instanceof ClassNotFoundException) {
            return t.toString();
        }
        if (t instanceof NoSuchMethodException) {
            return t.toString();
        }
        String s = t.getMessage();
        if (t.getCause() != null && t.getCause().toString().equals(s)) {
            return ExceptionUtil.getMsg(t.getCause());
        }
        if (t.getCause() == null) {
            if (UtilString.isEmpty(s)) {
                return t.toString();
            }
            return s;
        }
        String cause = ExceptionUtil.getMsg(t.getCause());
        if (UtilString.isNotEmpty(s) && UtilString.isNotEmpty(cause)) {
            return String.valueOf(s) + "\nCaused by: " + ExceptionUtil.getMsg(t.getCause());
        }
        if (UtilString.isEmpty(s) && UtilString.isNotEmpty(cause)) {
            return cause;
        }
        return s;
    }
}

