/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.i18n;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.server.conf.portal.LanguageModel;
import com.actionsoft.exception.AWSDataAccessException;
import com.actionsoft.exception.AWSObjectNotFindException;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.i18n.model.I18nModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class I18nDao {
    public int insert(String appId, File i18nFile, I18nModel model) throws AWSDataAccessException {
        String itemKey = model.getKey();
        List<LanguageModel> sysLangList = AWSPortalConf.getLanguages();
        this.checkFile(i18nFile);
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(i18nFile);
            Element rootElm = doc.getRootElement();
            Element langElm = rootElm.element("lang");
            Element newItem = langElm.addElement("item");
            newItem.addAttribute("key", itemKey);
            for (LanguageModel languageModel : sysLangList) {
                String langName = languageModel.getName();
                Element lang = newItem.addElement(langName);
                lang.addCDATA(model.getLanguages().get(langName).toString());
            }
            this.saveXML(appId, i18nFile, doc);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new AWSDataAccessException("XML\u6587\u6863\u5f02\u5e38");
        }
        return 1;
    }

    public int bacthInsert(String appId, File i18nFile, List<I18nModel> modelList) throws AWSDataAccessException {
        try {
            List<LanguageModel> sysLangList = AWSPortalConf.getLanguages();
            this.checkFile(i18nFile);
            SAXReader reader = new SAXReader();
            Document doc = reader.read(i18nFile);
            Element rootElm = doc.getRootElement();
            int i = 0;
            int size = modelList.size();
            while (i < size) {
                I18nModel model = modelList.get(i);
                String itemKey = model.getKey();
                Element langElm = rootElm.element("lang");
                Element newItem = langElm.addElement("item");
                newItem.addAttribute("key", itemKey);
                for (LanguageModel languageModel : sysLangList) {
                    String langName = languageModel.getName();
                    Element lang = newItem.addElement(langName);
                    lang.addCDATA(model.getLanguages().get(langName).toString());
                }
                ++i;
            }
            this.saveXML(appId, i18nFile, doc);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new AWSDataAccessException("XML\u6587\u6863\u5f02\u5e38");
        }
        return 1;
    }

    public int update(String appId, File i18nFile, I18nModel model) throws AWSDataAccessException {
        String itemKey = model.getKey();
        Map<String, String> languages = model.getLanguages();
        List<LanguageModel> sysLangList = AWSPortalConf.getLanguages();
        this.checkFile(i18nFile);
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(i18nFile);
            List list = doc.selectNodes("//locale-config/lang/item[@key='" + itemKey + "']");
            if (list.size() == 0) {
                throw new AWSObjectNotFindException("I18N\u8bed\u8a00\u9879\u5173\u952e\u5b57\uff1a" + itemKey + "\u5df2\u4e0d\u5b58\u5728");
            }
            for (Element element : list) {
                List itemList = element.elements();
                for (Element lang : itemList) {
                    lang.detach();
                }
                for (LanguageModel languageModel : sysLangList) {
                    String langName = languageModel.getName();
                    Element lang = element.addElement(langName);
                    lang.addCDATA(model.getLanguages().get(langName).toString());
                }
            }
            this.saveXML(appId, i18nFile, doc);
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new AWSDataAccessException("XML\u6587\u6863\u5f02\u5e38");
        }
    }

    public int delete(String appId, File i18nFile, String itemKey) throws AWSDataAccessException {
        this.checkFile(i18nFile);
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(i18nFile);
            Node node = doc.selectSingleNode("//locale-config/lang/item[@key='" + itemKey + "']");
            if (node != null) {
                node.detach();
                this.saveXML(appId, i18nFile, doc);
            }
            return 1;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new AWSDataAccessException("XML\u6587\u6863\u5f02\u5e38");
        }
    }

    private void checkFile(File i18nFile) {
        if (!(i18nFile.exists() && i18nFile.canRead() && i18nFile.canWrite())) {
            throw new AWSObjectNotFindException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + i18nFile.getName());
        }
        if (!i18nFile.canRead() || !i18nFile.canWrite()) {
            throw new AWSDataAccessException("\u6587\u4ef6\u8bbf\u95ee\u5f02\u5e38\uff1a" + i18nFile.getName());
        }
    }

    public synchronized void saveXML(String appId, File i18nFile, Document doc) throws AWSDataAccessException {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            format.setIndentSize(4);
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(i18nFile), format);
            writer.write(doc);
            writer.flush();
            writer.close();
            I18nRes.loadResource(AppsAPIManager.getInstance().getAppContext(appId), i18nFile, true, true);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new AWSDataAccessException("I18N\u6587\u4ef6\u7f16\u7801\u5f02\u5e38");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new AWSDataAccessException("I18N\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AWSDataAccessException("I18N\u6587\u4ef6\u8bfb\u5199\u5f02\u5e38");
        }
    }

    public static void main(String[] args) {
        File f = new File("E:/6.0/enterprise/release/apps/install/_bpm.platform/i18n/meta-menu2.xml");
        I18nModel m = new I18nModel();
        m.setKey("obj_fead799c3a08827271c12fb481382947");
        HashMap<String, String> lang = new HashMap<String, String>();
        lang.put("cn", "1");
        lang.put("en", "2");
        lang.put("big5", "3");
        m.setLanguages(lang);
        I18nDao dao = new I18nDao();
    }
}

