/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.i18n;

import com.actionsoft.bpms.commons.portal.navigation.util.NavigationUtil;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class I18nMetadataUtil {
    public static final String META_FILE = "metadata.xml";
    public static final String META_TYPE_COMPANY_NAME = "COMPANY_NAME_";
    public static final String META_TYPE_DEPARTMENT_NAME = "DEPARTMENT_NAME_";
    public static final String META_TYPE_USER_NAME = "USER_NAME_";
    public static final String META_TYPE_ROLE_NAME = "ROLE_NAME_";
    public static final String META_TYPE_ROLE_GROUP_NAME = "ROLE_GROUPNAME_";
    public static final String META_TYPE_TEAM_NAME = "TEAM_NAME_";
    public static final String META_TYPE_BO_NAME = "BO_NAME_";
    public static final String META_TYPE_BO_ITEM_NAME = "BO_ITEM_NAME_";
    public static final String META_TYPE_BO_ITEMVALUE = "BO_ITEMVALUE_";
    public static final String META_TYPE_DD_NAME = "DD_NAME_";
    public static final String META_TYPE_FORM_NAME = "FORM_NAME_";
    public static final String META_TYPE_PROCESS_GROUP_NAME = "PROCESS_GROUPNAME_";
    public static final String META_TYPE_PROCESS_NAME = "PROCESS_NAME_";
    public static final String META_TYPE_PROCESSNODE_NAME = "PROCESSNODE_NAME_";
    public static final String META_KEY_PROCESSNODE_COMMENT_NAME = "PROCESSNODE_COMMENTNAME_";
    public static final String META_KEY_DW_NAME = "DW_NAME_";
    public static final String META_KEY_DW_VIEW_NAME = "DW_VIEW_NAME_";
    public static final String META_KEY_NAV_NAME = "NAV_NAME_";
    public static final String META_KEY_APP_NAME = "APP_NAME_";

    public static void setRes(String key, Map<String, String> res) {
        I18nMetadataUtil.setRes("_bpm.platform", key, res);
    }

    public static void setRes(String appId, String metaType, String id, Map<String, String> res) {
        String key = String.valueOf(metaType) + id;
        I18nMetadataUtil.setRes(appId, key, res);
    }

    public static void setRes(String appId, String key, Map<String, String> res) {
        SDK.getI18NAPI().setRes(appId, META_FILE, key, res);
    }

    public static void removeRes(String metaType, String id) {
        I18nMetadataUtil.removeRes(metaType, id);
    }

    public static void removeRes(String appId, String metaType, String id) {
        String key = String.valueOf(metaType) + id;
        SDK.getI18NAPI().removeRes(appId, META_FILE, key);
    }

    public static Map<String, String> findValues(String metaType, String id) {
        return I18nMetadataUtil.findValues(metaType, id);
    }

    public static Map<String, String> findValues(String appId, String metaType, String id) {
        String key = String.valueOf(metaType) + id;
        JSONObject values = SDK.getI18NAPI().findValues(appId, key);
        if (values == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : values.keySet()) {
            map.put(s, values.getString(s));
        }
        return map;
    }

    public static String findValue(String metaType, String id, String lang, String originalVal) {
        if (SDK.getPlatformAPI().getDefaultLanguage().equals(lang)) {
            return originalVal;
        }
        return I18nMetadataUtil.findValue("_bpm.platform", metaType, id, lang, originalVal);
    }

    public static String findValue(String appId, String metaType, String id, String lang, String originalVal) {
        Map<String, String> res = I18nMetadataUtil.findValues(appId, metaType, id);
        if (res != null && res.containsKey(lang)) {
            String s = res.get(lang);
            if (UtilString.isEmpty(s)) {
                return I18nRes.findValue(appId, originalVal);
            }
            return s;
        }
        if (metaType.equals(META_KEY_NAV_NAME)) {
            return NavigationUtil.getLangName(lang, originalVal);
        }
        return I18nRes.findValue(appId, originalVal);
    }
}

