/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.i18n;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.model.def.ActivityModel;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.commons.mvc.dao.XDaoObject;
import com.actionsoft.bpms.commons.session.cache.SessionCache;
import com.actionsoft.bpms.server.AWSServer;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.Quota;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.ConsolePrinter;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class I18nRes {
    private static Map<String, Map<String, Map<String, String>>> i18nResList = new HashMap<String, Map<String, Map<String, String>>>();
    private static Map<String, Long> _fileInfo = new HashMap<String, Long>();
    private static Map<String, List<String>> keys = new HashMap<String, List<String>>();

    public static Map<String, Long> getFileInfo() {
        return _fileInfo;
    }

    public static int getResourceCountByApp(String appId) {
        Map<String, Map<String, String>> stringMapMap = i18nResList.get(appId);
        if (stringMapMap != null) {
            return stringMapMap.size();
        }
        return 0;
    }

    public static Map<String, Map<String, String>> getResourceMapByApp(String appId) {
        if (i18nResList.get(appId) == null) {
            i18nResList.put(appId, new HashMap());
        }
        return i18nResList.get(appId);
    }

    public static void loadInstancesByApp(AppContext app) {
        File[] bundles;
        String realPath = XDaoObject.getResourceRealPath(app.getId(), "i18n");
        File i18nDir = new File(realPath);
        if (!i18nDir.exists()) {
            return;
        }
        File[] fileArray = bundles = i18nDir.listFiles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            String filename;
            File file = fileArray[n2];
            if (!file.isDirectory() && (filename = file.getName()).toLowerCase().endsWith(".xml")) {
                I18nRes.loadResource(app, file, true, false);
            }
            ++n2;
        }
        if (I18nRes.getResourceMapByApp(app.getId()).size() > 0) {
            ConsolePrinter.info("[" + app.getName() + "]\u52a0\u8f7di18n\u8d44\u6e90\u9879[" + I18nRes.getResourceMapByApp(app.getId()).size() + "\u4e2a][\u6210\u529f]");
        }
    }

    private static Iterator getFileItems(AppContext app, File file) {
        SAXReader saxreader = new SAXReader();
        Document doc = DocumentFactory.getInstance().createDocument();
        Iterator localeConfigIT = null;
        try {
            doc = saxreader.read(file);
            localeConfigIT = doc.getRootElement().selectNodes("//locale-config/lang/item").iterator();
            if (localeConfigIT == null) {
                AppsLogger.err((AppContext)app, (String)("i18n\u8d44\u6e90\u6587\u4ef6[" + file.getName() + "]\u8bfb\u53d6\u5931\u8d25"), (String)"\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            AppsLogger.err((AppContext)app, (String)("i18n\u8d44\u6e90\u6587\u4ef6[" + file.getName() + "]\u8bfb\u53d6\u5931\u8d25"), (String)"\u68c0\u67e5\u9519\u8bef\u65e5\u5fd7", (Exception)e);
        }
        return localeConfigIT;
    }

    public static void loadResource(AppContext app, File file, boolean isCheck, boolean isRemove) {
        HashMap resList = new HashMap();
        Map<String, Map<String, String>> appResListAll = I18nRes.getResourceMapByApp(app.getId());
        if (isRemove) {
            I18nRes.destoryResource(app, file);
        }
        Iterator localeConfigIT = I18nRes.getFileItems(app, file);
        ArrayList<String> keyList = new ArrayList<String>();
        while (localeConfigIT != null && localeConfigIT.hasNext()) {
            Element e = (Element)localeConfigIT.next();
            String key = e.attributeValue("key");
            if (isCheck && appResListAll.containsKey(key)) {
                AppsLogger.warn((AppContext)app, (String)("i18n\u8d44\u6e90\u6587\u4ef6[" + file.getName() + "]\u9879[" + key + "]\u63cf\u8ff0\u91cd\u590d\uff01"));
                continue;
            }
            HashMap<String, String> langMap = new HashMap<String, String>();
            Iterator langItem = e.elementIterator();
            while (langItem.hasNext()) {
                Element lang = (Element)langItem.next();
                if (Quota.isI18n()) {
                    langMap.put(lang.getName(), lang.getText());
                    continue;
                }
                if (!lang.getName().equals(SDK.getPlatformAPI().getDefaultLanguage())) continue;
                langMap.put(lang.getName(), lang.getText());
            }
            resList.put(key, langMap);
            keyList.add(key);
        }
        keys.put(file.getPath(), keyList);
        _fileInfo.put(file.getPath(), file.lastModified());
        i18nResList.get(app.getId()).putAll(resList);
    }

    public static void destoryResource(AppContext app, File file) {
        Map<String, Map<String, String>> resList = I18nRes.getResourceMapByApp(app.getId());
        if (keys.containsKey(file.getPath())) {
            for (String key : keys.get(file.getPath())) {
                if (!resList.containsKey(key)) continue;
                resList.remove(key);
            }
        }
        keys.remove(file.getPath());
        _fileInfo.remove(file.getPath());
    }

    public static String getUserLanguage() {
        String[] split;
        String sid;
        UserContext me = DispatcherRequest.getUserContext();
        if (me == null && DispatcherRequest.getContext() != null && UtilString.isNotEmpty(sid = DispatcherRequest.getContext().getSid()) && SessionCache.getModel((String)sid) != null) {
            me = UserContext.fromSessionId((String)sid);
        }
        if (me != null) {
            return me.getLanguage();
        }
        String threadName = Thread.currentThread().getName();
        if (threadName.contains("-lang[")) {
            int index = threadName.indexOf("-lang[");
            return threadName.substring(index + 6, index + 8);
        }
        if (threadName.startsWith("UPFILE") && (split = threadName.split("--")).length == 4) {
            return split[3];
        }
        return "cn";
    }

    public static String findValue(String appId, String key) {
        try {
            return I18nRes.findValue(appId, I18nRes.getUserLanguage(), key);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return key;
        }
    }

    public static String findValue(String appId, String locale, String key) {
        return I18nRes.findValue(appId, locale, key, new Object[0]);
    }

    public static String findValue(String appId, String locale, String key, Object ... replaceValue) {
        Map<String, String> bundleMaps;
        AppContext appContext;
        String v = "";
        if (i18nResList.get(appId) == null && (appContext = AppsAPIManager.getInstance().getAppContext(appId)) != null && AWSServer.getInstance().isServiceReady() && appContext.getRuntimeState().equals("ACTIVE")) {
            I18nRes.loadInstancesByApp(appContext);
        }
        v = (bundleMaps = I18nRes.getResourceMapByApp(appId).get(key)) == null ? key : bundleMaps.get(locale);
        if (!UtilString.isEmpty(replaceValue)) {
            int i = 0;
            while (i < replaceValue.length) {
                v = v.replace("{" + i + "}", String.valueOf(replaceValue[i]));
                ++i;
            }
        }
        return v;
    }

    public static Map findValues(String appId, String key) {
        AppContext appContext;
        String v = "";
        if (i18nResList.get(appId) == null && (appContext = AppsAPIManager.getInstance().getAppContext(appId)) != null && AWSServer.getInstance().isServiceReady() && appContext.getRuntimeState().equals("ACTIVE")) {
            I18nRes.loadInstancesByApp(appContext);
        }
        return I18nRes.getResourceMapByApp(appId).get(key);
    }

    @Deprecated
    public static String findValue(String appId, String locale, String key, String repleaseValue) {
        if (repleaseValue != null && repleaseValue.length() > 0) {
            List<String> vc = new UtilString(repleaseValue).split("|");
            return I18nRes.findValue(appId, locale, key, vc.toArray());
        }
        return I18nRes.findValue(appId, locale, key);
    }

    public static String findValueByProcessTitle(String lang, String title) {
        return I18nRes.findValueByProcessTitle(lang, title, "");
    }

    public static String findValueByProcessTitle(String lang, String title, String processDefId) {
        ProcessDefinition processDefinition;
        List<Object> keys = new ArrayList();
        String processTitleKeys = SDK.getAppAPI().getProperty("_bpm.portal", "processTitleI18NKeys");
        if (UtilString.isNotEmpty(processTitleKeys)) {
            keys = new UtilString(processTitleKeys).split(",");
            for (String string : keys) {
                if (!title.contains(string)) continue;
                String sI18n = I18nRes.findValue("_bpm.portal", lang, string);
                title = title.replace(string, sI18n);
            }
        }
        if (UtilString.isNotEmpty(processDefId) && (processDefinition = (ProcessDefinition)ProcessDefCache.getInstance().getModel(processDefId)) != null) {
            for (ActivityModel activityModel : processDefinition.getTasks().values()) {
                String value = activityModel.getNameI18N();
                title = title.replace("(" + activityModel.getName() + ")", "(" + value + ")");
            }
        }
        title = title.replaceAll("<", "&lt;");
        return title;
    }

    public static void destoryInstancesByApp(AppContext app) {
        Map<String, Map<String, String>> tmpMap = i18nResList.get(app.getId());
        i18nResList.remove(app.getId());
        if (tmpMap != null && tmpMap.size() > 0) {
            ConsolePrinter.info("[" + app.getName() + "]\u505c\u7528i18n\u8d44\u6e90\u9879[" + I18nRes.getResourceMapByApp(app.getId()).size() + "\u4e2a][\u6210\u529f]");
        }
    }

    public static void updateFileCache(AppContext app, File file) {
        String fileName = file.getName();
        if (_fileInfo != null) {
            if (_fileInfo.containsKey(file.getPath())) {
                ConsolePrinter.info("[" + app.getName() + "][" + fileName + "][\u66f4\u65b0]");
                I18nRes.loadResource(app, file, false, true);
            } else {
                ConsolePrinter.info("[" + app.getName() + "][" + fileName + "][\u53d1\u73b0]");
                I18nRes.loadResource(app, file, true, false);
            }
        }
    }

    public static void removeFileCache(AppContext app, File file) {
        if (_fileInfo != null) {
            I18nRes.destoryResource(app, file);
            ConsolePrinter.info("[" + app.getName() + "][" + file.getName() + "][\u5220\u9664]");
        }
    }
}

