/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.i18n;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.scanner.AbstScanner;
import com.actionsoft.apps.resource.scanner.IScanner;
import com.actionsoft.i18n.I18nRes;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public class I18nResScanner
extends AbstScanner
implements IScanner {
    public I18nResScanner() {
        this.setName("AWS i18n Scanner");
        this.setInterval(5000L);
    }

    public void scan() {
        for (AppContext app : AppsAPIManager.getInstance().getInstalledApps()) {
            if (!app.getRuntimeState().equals("ACTIVE") || !app.isReloadable()) continue;
            String scanPath = String.valueOf(app.getPath()) + "i18n";
            Map<String, Long> fileInfo = I18nRes.getFileInfo();
            File dir = new File(scanPath);
            File[] files = dir.listFiles();
            if (files == null) continue;
            ArrayList<String> deletedFiles = new ArrayList<String>();
            for (String filePath : fileInfo.keySet()) {
                if (filePath.indexOf("/" + app.getId() + "/") <= 0 && filePath.indexOf("\\" + app.getId() + "\\") <= 0) continue;
                deletedFiles.add(filePath);
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName;
                File file = fileArray[n2];
                if (!file.isDirectory() && (fileName = file.getName()).toLowerCase().endsWith(".xml")) {
                    if (fileInfo.containsKey(file.getPath())) {
                        Long lastModify = fileInfo.get(file.getPath());
                        if (lastModify.longValue() != file.lastModified()) {
                            I18nRes.updateFileCache(app, file);
                        }
                    } else {
                        I18nRes.updateFileCache(app, file);
                    }
                    deletedFiles.remove(file.getPath());
                }
                ++n2;
            }
            for (String filePath : deletedFiles) {
                I18nRes.removeFileCache(app, new File(filePath));
            }
        }
    }
}

