/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.i18n.web;

import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.Quota;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.server.conf.portal.LanguageModel;
import com.actionsoft.bpms.util.JavascriptEscape;
import com.actionsoft.i18n.I18nMetadataUtil;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import java.util.Map;

public class I18NWeb {
    private UserContext me = null;

    public UserContext getMe() {
        return this.me;
    }

    public I18NWeb(UserContext me) {
        this.me = me;
    }

    public String saveMetadata(String appId, String metadataType, String key, String res) {
        JSONObject data = JSONObject.parseObject((String)JavascriptEscape.unescape(res));
        Map params = (Map)JSONObject.parseObject((String)data.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        I18nMetadataUtil.setRes(appId, key, params);
        return ResponseObject.newOkResponse().toString();
    }

    public String queryMetadata(String appId, String metadataType, String key) {
        if (SDK.getAppAPI().isActive(appId)) {
            String[] keys = key.split(",");
            JSONObject dataInfos = new JSONObject();
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                JSONObject data = SDK.getI18NAPI().findValues(appId, k);
                dataInfos.put(k, (Object)(data == null ? new JSONObject() : data));
                ++n2;
            }
            ResponseObject ro = ResponseObject.newOkResponse();
            ro.put("dataInfos", dataInfos);
            return ro.toString();
        }
        ResponseObject ro = ResponseObject.newWarnResponse().msg(I18nRes.findValue("_bpm.platform", "\u8be5\u5bfc\u822a\u7684\u5e94\u7528\u672a\u5b89\u88c5\u6216\u672a\u542f\u52a8"));
        return ro.toString();
    }

    public String getMetadataLangs() {
        ResponseObject ro = ResponseObject.newOkResponse();
        List<LanguageModel> languages = AWSPortalConf.getLanguages();
        JSONArray array = new JSONArray();
        for (LanguageModel language : languages) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)language.getName());
            object.put("title", (Object)language.getTitle());
            if (language.isDefault()) {
                array.add(0, (Object)object);
                continue;
            }
            array.add((Object)object);
        }
        if (Quota.isI18n()) {
            ro.put("langList", array.toString());
        } else {
            ro.put("isI18n", false);
        }
        return ro.toString();
    }
}

