/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalTokenizer;
import com.azure.search.documents.indexes.models.TokenCharacterKind;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class EdgeNGramTokenizer
extends LexicalTokenizer {
    private Integer minGram;
    private Integer maxGram;
    private List<TokenCharacterKind> tokenChars;

    public EdgeNGramTokenizer(String name) {
        super(name);
    }

    public Integer getMinGram() {
        return this.minGram;
    }

    public EdgeNGramTokenizer setMinGram(Integer minGram) {
        this.minGram = minGram;
        return this;
    }

    public Integer getMaxGram() {
        return this.maxGram;
    }

    public EdgeNGramTokenizer setMaxGram(Integer maxGram) {
        this.maxGram = maxGram;
        return this;
    }

    public List<TokenCharacterKind> getTokenChars() {
        return this.tokenChars;
    }

    public EdgeNGramTokenizer setTokenChars(List<TokenCharacterKind> tokenChars) {
        this.tokenChars = tokenChars;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.EdgeNGramTokenizer");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeNumberField("minGram", (Number)this.minGram);
        jsonWriter.writeNumberField("maxGram", (Number)this.maxGram);
        jsonWriter.writeArrayField("tokenChars", this.tokenChars, (writer, element) -> writer.writeString(Objects.toString(element, null)));
        return jsonWriter.writeEndObject();
    }

    public static EdgeNGramTokenizer fromJson(JsonReader jsonReader) throws IOException {
        return (EdgeNGramTokenizer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Integer minGram = null;
            Integer maxGram = null;
            List tokenChars = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.EdgeNGramTokenizer".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.EdgeNGramTokenizer'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("minGram".equals(fieldName)) {
                    minGram = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxGram".equals(fieldName)) {
                    maxGram = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("tokenChars".equals(fieldName)) {
                    tokenChars = reader.readArray(reader1 -> TokenCharacterKind.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                EdgeNGramTokenizer deserializedEdgeNGramTokenizer = new EdgeNGramTokenizer(name);
                deserializedEdgeNGramTokenizer.minGram = minGram;
                deserializedEdgeNGramTokenizer.maxGram = maxGram;
                deserializedEdgeNGramTokenizer.tokenChars = tokenChars;
                return deserializedEdgeNGramTokenizer;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public EdgeNGramTokenizer setTokenChars(TokenCharacterKind ... tokenChars) {
        this.tokenChars = tokenChars == null ? null : Arrays.asList(tokenChars);
        return this;
    }
}

