/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;

public final class FreshnessScoringParameters
implements JsonSerializable<FreshnessScoringParameters> {
    private final Duration boostingDuration;

    public FreshnessScoringParameters(Duration boostingDuration) {
        this.boostingDuration = boostingDuration;
    }

    public Duration getBoostingDuration() {
        return this.boostingDuration;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("boostingDuration", Objects.toString(this.boostingDuration, null));
        return jsonWriter.writeEndObject();
    }

    public static FreshnessScoringParameters fromJson(JsonReader jsonReader) throws IOException {
        return (FreshnessScoringParameters)jsonReader.readObject(reader -> {
            boolean boostingDurationFound = false;
            Duration boostingDuration = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("boostingDuration".equals(fieldName)) {
                    boostingDuration = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    boostingDurationFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (boostingDurationFound) {
                FreshnessScoringParameters deserializedFreshnessScoringParameters = new FreshnessScoringParameters(boostingDuration);
                return deserializedFreshnessScoringParameters;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!boostingDurationFound) {
                missingProperties.add("boostingDuration");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

