/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.VectorSearchAlgorithmMetric;
import java.io.IOException;
import java.util.Objects;

public final class HnswParameters
implements JsonSerializable<HnswParameters> {
    private Integer m;
    private Integer efConstruction;
    private Integer efSearch;
    private VectorSearchAlgorithmMetric metric;

    public Integer getM() {
        return this.m;
    }

    public HnswParameters setM(Integer m) {
        this.m = m;
        return this;
    }

    public Integer getEfConstruction() {
        return this.efConstruction;
    }

    public HnswParameters setEfConstruction(Integer efConstruction) {
        this.efConstruction = efConstruction;
        return this;
    }

    public Integer getEfSearch() {
        return this.efSearch;
    }

    public HnswParameters setEfSearch(Integer efSearch) {
        this.efSearch = efSearch;
        return this;
    }

    public VectorSearchAlgorithmMetric getMetric() {
        return this.metric;
    }

    public HnswParameters setMetric(VectorSearchAlgorithmMetric metric) {
        this.metric = metric;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("m", (Number)this.m);
        jsonWriter.writeNumberField("efConstruction", (Number)this.efConstruction);
        jsonWriter.writeNumberField("efSearch", (Number)this.efSearch);
        jsonWriter.writeStringField("metric", Objects.toString((Object)this.metric, null));
        return jsonWriter.writeEndObject();
    }

    public static HnswParameters fromJson(JsonReader jsonReader) throws IOException {
        return (HnswParameters)jsonReader.readObject(reader -> {
            HnswParameters deserializedHnswParameters = new HnswParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("m".equals(fieldName)) {
                    deserializedHnswParameters.m = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("efConstruction".equals(fieldName)) {
                    deserializedHnswParameters.efConstruction = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("efSearch".equals(fieldName)) {
                    deserializedHnswParameters.efSearch = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("metric".equals(fieldName)) {
                    deserializedHnswParameters.metric = VectorSearchAlgorithmMetric.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHnswParameters;
        });
    }
}

