/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.resourcemanager.cosmos.models.CompositePath;
import com.azure.resourcemanager.cosmos.models.ExcludedPath;
import com.azure.resourcemanager.cosmos.models.IncludedPath;
import com.azure.resourcemanager.cosmos.models.IndexingMode;
import com.azure.resourcemanager.cosmos.models.SpatialSpec;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class IndexingPolicy {
    @JsonProperty(value="automatic")
    private Boolean automatic;
    @JsonProperty(value="indexingMode")
    private IndexingMode indexingMode;
    @JsonProperty(value="includedPaths")
    private List<IncludedPath> includedPaths;
    @JsonProperty(value="excludedPaths")
    private List<ExcludedPath> excludedPaths;
    @JsonProperty(value="compositeIndexes")
    private List<List<CompositePath>> compositeIndexes;
    @JsonProperty(value="spatialIndexes")
    private List<SpatialSpec> spatialIndexes;

    public Boolean automatic() {
        return this.automatic;
    }

    public IndexingPolicy withAutomatic(Boolean automatic) {
        this.automatic = automatic;
        return this;
    }

    public IndexingMode indexingMode() {
        return this.indexingMode;
    }

    public IndexingPolicy withIndexingMode(IndexingMode indexingMode) {
        this.indexingMode = indexingMode;
        return this;
    }

    public List<IncludedPath> includedPaths() {
        return this.includedPaths;
    }

    public IndexingPolicy withIncludedPaths(List<IncludedPath> includedPaths) {
        this.includedPaths = includedPaths;
        return this;
    }

    public List<ExcludedPath> excludedPaths() {
        return this.excludedPaths;
    }

    public IndexingPolicy withExcludedPaths(List<ExcludedPath> excludedPaths) {
        this.excludedPaths = excludedPaths;
        return this;
    }

    public List<List<CompositePath>> compositeIndexes() {
        return this.compositeIndexes;
    }

    public IndexingPolicy withCompositeIndexes(List<List<CompositePath>> compositeIndexes) {
        this.compositeIndexes = compositeIndexes;
        return this;
    }

    public List<SpatialSpec> spatialIndexes() {
        return this.spatialIndexes;
    }

    public IndexingPolicy withSpatialIndexes(List<SpatialSpec> spatialIndexes) {
        this.spatialIndexes = spatialIndexes;
        return this;
    }

    public void validate() {
        if (this.includedPaths() != null) {
            this.includedPaths().forEach(e -> e.validate());
        }
        if (this.excludedPaths() != null) {
            this.excludedPaths().forEach(e -> e.validate());
        }
        if (this.compositeIndexes() != null) {
            this.compositeIndexes().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
        if (this.spatialIndexes() != null) {
            this.spatialIndexes().forEach(e -> e.validate());
        }
    }
}

