/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc;

import com.baidu.brpc.protocol.ProtocolFactory;
import com.baidu.brpc.protocol.ProtocolManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;

public class CommunicationSpiManager {
    private static volatile CommunicationSpiManager instance;
    private Object loadLock = new Object();
    private Boolean isLoaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommunicationSpiManager getInstance() {
        if (instance != null) return instance;
        Class<CommunicationSpiManager> clazz = CommunicationSpiManager.class;
        synchronized (CommunicationSpiManager.class) {
            if (instance != null) return instance;
            instance = new CommunicationSpiManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllExtensions(String encoding) {
        if (!this.isLoaded.booleanValue()) {
            Object object = this.loadLock;
            synchronized (object) {
                if (!this.isLoaded.booleanValue()) {
                    this.loadProtocol(encoding);
                    this.isLoaded = true;
                }
            }
        }
    }

    public void loadProtocol(String encoding) {
        ProtocolManager protocolManager = ProtocolManager.getInstance();
        ServiceLoader<ProtocolFactory> protocolFactories = ServiceLoader.load(ProtocolFactory.class);
        ArrayList<ProtocolFactory> protocolFactoryList = new ArrayList<ProtocolFactory>();
        for (ProtocolFactory protocolFactory : protocolFactories) {
            protocolFactoryList.add(protocolFactory);
        }
        Collections.sort(protocolFactoryList, new Comparator<ProtocolFactory>(){

            @Override
            public int compare(ProtocolFactory o1, ProtocolFactory o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        for (ProtocolFactory protocolFactory : protocolFactoryList) {
            protocolManager.registerProtocol(protocolFactory, encoding);
        }
    }
}

