/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client;

import com.baidu.brpc.client.channel.ChannelType;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.protocol.Options;
import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.utils.BrpcConstants;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationOptions {
    private static final Logger log = LoggerFactory.getLogger(CommunicationOptions.class);
    private Protocol protocol;
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private int connectTimeoutMillis = 1000;
    private int readTimeoutMillis = 1000;
    private int writeTimeoutMillis = 1000;
    private int maxTotalConnections = 8;
    private int minIdleConnections = 8;
    private int maxTryTimes = 3;
    private long timeBetweenEvictionRunsMillis = 300000L;
    private int latencyWindowSizeOfFairLoadBalance = 30;
    private int healthyCheckIntervalMillis = 3000;
    private boolean keepAlive = true;
    private boolean reuseAddr = true;
    private boolean tcpNoDelay = true;
    private int soLinger = 5;
    private int backlog = 100;
    private int receiveBufferSize = 65536;
    private int sendBufferSize = 65536;
    private int keepAliveTime = 300;
    private int ioThreadNum = Runtime.getRuntime().availableProcessors();
    private int workThreadNum = Runtime.getRuntime().availableProcessors();
    private int ioEventType = BrpcConstants.IO_EVENT_JDK;
    private int futureBufferSize = 1000000;
    private String encoding = "utf-8";
    private Options.CompressType compressType = Options.CompressType.COMPRESS_TYPE_NONE;
    private ChannelType channelType = ChannelType.POOLED_CONNECTION;
    private String clientName;
    private boolean globalThreadPoolSharing = false;

    public CommunicationOptions clone() {
        CommunicationOptionsBuilder builder = CommunicationOptions.builder().protocol(this.protocol).interceptors(this.interceptors).backlog(this.backlog).channelType(this.channelType).compressType(this.compressType).connectTimeoutMillis(this.connectTimeoutMillis).encoding(this.encoding).healthyCheckIntervalMillis(this.healthyCheckIntervalMillis).ioThreadNum(this.ioThreadNum).keepAlive(this.keepAlive).keepAliveTime(this.keepAliveTime).maxTotalConnections(this.maxTotalConnections).maxTryTimes(this.maxTryTimes).minIdleConnections(this.minIdleConnections).readTimeoutMillis(this.readTimeoutMillis).receiveBufferSize(this.receiveBufferSize).reuseAddr(this.reuseAddr).sendBufferSize(this.sendBufferSize).soLinger(this.soLinger).tcpNoDelay(this.tcpNoDelay).timeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis).workThreadNum(this.workThreadNum).writeTimeoutMillis(this.writeTimeoutMillis).clientName(this.clientName).globalThreadPoolSharing(this.globalThreadPoolSharing);
        return builder.build();
    }

    CommunicationOptions(Protocol protocol, List<Interceptor> interceptors, int connectTimeoutMillis, int readTimeoutMillis, int writeTimeoutMillis, int maxTotalConnections, int minIdleConnections, int maxTryTimes, long timeBetweenEvictionRunsMillis, int latencyWindowSizeOfFairLoadBalance, int healthyCheckIntervalMillis, boolean keepAlive, boolean reuseAddr, boolean tcpNoDelay, int soLinger, int backlog, int receiveBufferSize, int sendBufferSize, int keepAliveTime, int ioThreadNum, int workThreadNum, int ioEventType, int futureBufferSize, String encoding, Options.CompressType compressType, ChannelType channelType, String clientName, boolean globalThreadPoolSharing) {
        this.protocol = protocol;
        this.interceptors = interceptors;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.maxTotalConnections = maxTotalConnections;
        this.minIdleConnections = minIdleConnections;
        this.maxTryTimes = maxTryTimes;
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.latencyWindowSizeOfFairLoadBalance = latencyWindowSizeOfFairLoadBalance;
        this.healthyCheckIntervalMillis = healthyCheckIntervalMillis;
        this.keepAlive = keepAlive;
        this.reuseAddr = reuseAddr;
        this.tcpNoDelay = tcpNoDelay;
        this.soLinger = soLinger;
        this.backlog = backlog;
        this.receiveBufferSize = receiveBufferSize;
        this.sendBufferSize = sendBufferSize;
        this.keepAliveTime = keepAliveTime;
        this.ioThreadNum = ioThreadNum;
        this.workThreadNum = workThreadNum;
        this.ioEventType = ioEventType;
        this.futureBufferSize = futureBufferSize;
        this.encoding = encoding;
        this.compressType = compressType;
        this.channelType = channelType;
        this.clientName = clientName;
        this.globalThreadPoolSharing = globalThreadPoolSharing;
    }

    public static CommunicationOptionsBuilder builder() {
        return new CommunicationOptionsBuilder();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public int getWriteTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int getMinIdleConnections() {
        return this.minIdleConnections;
    }

    public int getMaxTryTimes() {
        return this.maxTryTimes;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public int getLatencyWindowSizeOfFairLoadBalance() {
        return this.latencyWindowSizeOfFairLoadBalance;
    }

    public int getHealthyCheckIntervalMillis() {
        return this.healthyCheckIntervalMillis;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isReuseAddr() {
        return this.reuseAddr;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public int getIoThreadNum() {
        return this.ioThreadNum;
    }

    public int getWorkThreadNum() {
        return this.workThreadNum;
    }

    public int getIoEventType() {
        return this.ioEventType;
    }

    public int getFutureBufferSize() {
        return this.futureBufferSize;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Options.CompressType getCompressType() {
        return this.compressType;
    }

    public ChannelType getChannelType() {
        return this.channelType;
    }

    public String getClientName() {
        return this.clientName;
    }

    public boolean isGlobalThreadPoolSharing() {
        return this.globalThreadPoolSharing;
    }

    public static class CommunicationOptionsBuilder {
        private Protocol protocol;
        private List<Interceptor> interceptors;
        private int connectTimeoutMillis;
        private int readTimeoutMillis;
        private int writeTimeoutMillis;
        private int maxTotalConnections;
        private int minIdleConnections;
        private int maxTryTimes;
        private long timeBetweenEvictionRunsMillis;
        private int latencyWindowSizeOfFairLoadBalance;
        private int healthyCheckIntervalMillis;
        private boolean keepAlive;
        private boolean reuseAddr;
        private boolean tcpNoDelay;
        private int soLinger;
        private int backlog;
        private int receiveBufferSize;
        private int sendBufferSize;
        private int keepAliveTime;
        private int ioThreadNum;
        private int workThreadNum;
        private int ioEventType;
        private int futureBufferSize;
        private String encoding;
        private Options.CompressType compressType;
        private ChannelType channelType;
        private String clientName;
        private boolean globalThreadPoolSharing;

        CommunicationOptionsBuilder() {
        }

        public CommunicationOptionsBuilder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public CommunicationOptionsBuilder interceptors(List<Interceptor> interceptors) {
            this.interceptors = interceptors;
            return this;
        }

        public CommunicationOptionsBuilder connectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public CommunicationOptionsBuilder readTimeoutMillis(int readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public CommunicationOptionsBuilder writeTimeoutMillis(int writeTimeoutMillis) {
            this.writeTimeoutMillis = writeTimeoutMillis;
            return this;
        }

        public CommunicationOptionsBuilder maxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public CommunicationOptionsBuilder minIdleConnections(int minIdleConnections) {
            this.minIdleConnections = minIdleConnections;
            return this;
        }

        public CommunicationOptionsBuilder maxTryTimes(int maxTryTimes) {
            this.maxTryTimes = maxTryTimes;
            return this;
        }

        public CommunicationOptionsBuilder timeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
            this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
            return this;
        }

        public CommunicationOptionsBuilder latencyWindowSizeOfFairLoadBalance(int latencyWindowSizeOfFairLoadBalance) {
            this.latencyWindowSizeOfFairLoadBalance = latencyWindowSizeOfFairLoadBalance;
            return this;
        }

        public CommunicationOptionsBuilder healthyCheckIntervalMillis(int healthyCheckIntervalMillis) {
            this.healthyCheckIntervalMillis = healthyCheckIntervalMillis;
            return this;
        }

        public CommunicationOptionsBuilder keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public CommunicationOptionsBuilder reuseAddr(boolean reuseAddr) {
            this.reuseAddr = reuseAddr;
            return this;
        }

        public CommunicationOptionsBuilder tcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return this;
        }

        public CommunicationOptionsBuilder soLinger(int soLinger) {
            this.soLinger = soLinger;
            return this;
        }

        public CommunicationOptionsBuilder backlog(int backlog) {
            this.backlog = backlog;
            return this;
        }

        public CommunicationOptionsBuilder receiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return this;
        }

        public CommunicationOptionsBuilder sendBufferSize(int sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
            return this;
        }

        public CommunicationOptionsBuilder keepAliveTime(int keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        public CommunicationOptionsBuilder ioThreadNum(int ioThreadNum) {
            this.ioThreadNum = ioThreadNum;
            return this;
        }

        public CommunicationOptionsBuilder workThreadNum(int workThreadNum) {
            this.workThreadNum = workThreadNum;
            return this;
        }

        public CommunicationOptionsBuilder ioEventType(int ioEventType) {
            this.ioEventType = ioEventType;
            return this;
        }

        public CommunicationOptionsBuilder futureBufferSize(int futureBufferSize) {
            this.futureBufferSize = futureBufferSize;
            return this;
        }

        public CommunicationOptionsBuilder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public CommunicationOptionsBuilder compressType(Options.CompressType compressType) {
            this.compressType = compressType;
            return this;
        }

        public CommunicationOptionsBuilder channelType(ChannelType channelType) {
            this.channelType = channelType;
            return this;
        }

        public CommunicationOptionsBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public CommunicationOptionsBuilder globalThreadPoolSharing(boolean globalThreadPoolSharing) {
            this.globalThreadPoolSharing = globalThreadPoolSharing;
            return this;
        }

        public CommunicationOptions build() {
            return new CommunicationOptions(this.protocol, this.interceptors, this.connectTimeoutMillis, this.readTimeoutMillis, this.writeTimeoutMillis, this.maxTotalConnections, this.minIdleConnections, this.maxTryTimes, this.timeBetweenEvictionRunsMillis, this.latencyWindowSizeOfFairLoadBalance, this.healthyCheckIntervalMillis, this.keepAlive, this.reuseAddr, this.tcpNoDelay, this.soLinger, this.backlog, this.receiveBufferSize, this.sendBufferSize, this.keepAliveTime, this.ioThreadNum, this.workThreadNum, this.ioEventType, this.futureBufferSize, this.encoding, this.compressType, this.channelType, this.clientName, this.globalThreadPoolSharing);
        }

        public String toString() {
            return "CommunicationOptions.CommunicationOptionsBuilder(protocol=" + this.protocol + ", interceptors=" + this.interceptors + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", readTimeoutMillis=" + this.readTimeoutMillis + ", writeTimeoutMillis=" + this.writeTimeoutMillis + ", maxTotalConnections=" + this.maxTotalConnections + ", minIdleConnections=" + this.minIdleConnections + ", maxTryTimes=" + this.maxTryTimes + ", timeBetweenEvictionRunsMillis=" + this.timeBetweenEvictionRunsMillis + ", latencyWindowSizeOfFairLoadBalance=" + this.latencyWindowSizeOfFairLoadBalance + ", healthyCheckIntervalMillis=" + this.healthyCheckIntervalMillis + ", keepAlive=" + this.keepAlive + ", reuseAddr=" + this.reuseAddr + ", tcpNoDelay=" + this.tcpNoDelay + ", soLinger=" + this.soLinger + ", backlog=" + this.backlog + ", receiveBufferSize=" + this.receiveBufferSize + ", sendBufferSize=" + this.sendBufferSize + ", keepAliveTime=" + this.keepAliveTime + ", ioThreadNum=" + this.ioThreadNum + ", workThreadNum=" + this.workThreadNum + ", ioEventType=" + this.ioEventType + ", futureBufferSize=" + this.futureBufferSize + ", encoding=" + this.encoding + ", compressType=" + (Object)((Object)this.compressType) + ", channelType=" + (Object)((Object)this.channelType) + ", clientName=" + this.clientName + ", globalThreadPoolSharing=" + this.globalThreadPoolSharing + ")";
        }
    }
}

