/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.channel;

import com.baidu.brpc.client.CommunicationOptions;
import com.baidu.brpc.client.channel.ChannelType;
import com.baidu.brpc.client.handler.IdleChannelHandler;
import com.baidu.brpc.client.handler.RpcClientHandler;
import com.baidu.brpc.thread.BrpcThreadPoolManager;
import com.baidu.brpc.utils.BrpcConstants;
import com.baidu.brpc.utils.ThreadPool;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapManager {
    private static final Logger log = LoggerFactory.getLogger(BootstrapManager.class);
    private ConcurrentMap<String, Bootstrap> bootstrapMap = new ConcurrentHashMap<String, Bootstrap>();
    private static volatile BootstrapManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BootstrapManager getInstance() {
        if (instance != null) return instance;
        Class<BootstrapManager> clazz = BootstrapManager.class;
        synchronized (BootstrapManager.class) {
            if (instance != null) return instance;
            instance = new BootstrapManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Bootstrap getOrCreateBootstrap(String serviceName, CommunicationOptions communicationOptions) {
        Bootstrap bootstrap = (Bootstrap)this.bootstrapMap.get(serviceName);
        if (bootstrap != null) {
            return bootstrap;
        }
        bootstrap = this.createBooStrap(serviceName, communicationOptions);
        Bootstrap prev = this.bootstrapMap.putIfAbsent(serviceName, bootstrap);
        if (prev != null) {
            log.warn("prev bootstrap exist for service:{}", (Object)serviceName);
            if (!communicationOptions.isGlobalThreadPoolSharing()) {
                // empty if block
            }
        }
        return bootstrap;
    }

    public Bootstrap createBooStrap(String serviceName, final CommunicationOptions communicationOptions) {
        Bootstrap bootstrap = new Bootstrap();
        if (communicationOptions.getIoEventType() == BrpcConstants.IO_EVENT_NETTY_EPOLL) {
            bootstrap.channel(EpollSocketChannel.class);
            bootstrap.option(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED);
        } else {
            bootstrap.channel(NioSocketChannel.class);
        }
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)communicationOptions.getConnectTimeoutMillis());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)communicationOptions.isKeepAlive());
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)communicationOptions.isReuseAddr());
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)communicationOptions.isTcpNoDelay());
        bootstrap.option(ChannelOption.SO_RCVBUF, (Object)communicationOptions.getReceiveBufferSize());
        bootstrap.option(ChannelOption.SO_SNDBUF, (Object)communicationOptions.getSendBufferSize());
        BrpcThreadPoolManager threadPoolManager = BrpcThreadPoolManager.getInstance();
        boolean isSharing = communicationOptions.isGlobalThreadPoolSharing();
        ThreadPool workThreadPool = threadPoolManager.getOrCreateClientWorkThreadPool(serviceName, isSharing, communicationOptions.getWorkThreadNum());
        ExecutorService exceptionThreadPool = threadPoolManager.getExceptionThreadPool();
        final RpcClientHandler rpcClientHandler = new RpcClientHandler(workThreadPool, exceptionThreadPool);
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                if (communicationOptions.getChannelType() == ChannelType.SINGLE_CONNECTION) {
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, communicationOptions.getKeepAliveTime())});
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleChannelHandler()});
                }
                ch.pipeline().addLast(new ChannelHandler[]{rpcClientHandler});
            }
        };
        EventLoopGroup ioThreadPool = threadPoolManager.getOrCreateClientIoThreadPool(serviceName, isSharing, communicationOptions.getIoThreadNum(), communicationOptions.getIoEventType());
        ((Bootstrap)bootstrap.group(ioThreadPool)).handler((ChannelHandler)initializer);
        return bootstrap;
    }

    public Bootstrap removeBootstrap(String serviceName) {
        return (Bootstrap)this.bootstrapMap.remove(serviceName);
    }

    public void removeAll() {
        this.bootstrapMap.clear();
    }
}

