/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.dubbo;

import com.alibaba.com.caucho.hessian.io.Hessian2Input;
import com.alibaba.com.caucho.hessian.io.Hessian2Output;
import com.alibaba.com.caucho.hessian.io.SerializerFactory;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.protocol.dubbo.ReflectUtils;
import com.baidu.brpc.server.ServiceManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboRequestBody {
    private static final Logger log = LoggerFactory.getLogger(DubboRequestBody.class);
    public static final SerializerFactory SERIALIZER_FACTORY = new SerializerFactory();
    private String dubboProtocolVersion = "2.7.5";
    private String path;
    private String version;
    private String methodName;
    private Class<?>[] parameterTypes;
    private Object[] arguments;
    private Map<String, String> attachments = new HashMap<String, String>();
    private RpcMethodInfo rpcMethodInfo;

    public byte[] encodeRequestBody() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Hessian2Output hessian2Output = new Hessian2Output((OutputStream)outputStream);
        hessian2Output.setSerializerFactory(SERIALIZER_FACTORY);
        hessian2Output.writeString(this.dubboProtocolVersion);
        hessian2Output.writeString(this.path);
        hessian2Output.writeString(this.version);
        hessian2Output.writeString(this.methodName);
        hessian2Output.writeString(ReflectUtils.getDesc(this.parameterTypes));
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                hessian2Output.writeObject(this.arguments[i]);
            }
        }
        if (this.attachments != null) {
            hessian2Output.writeObject(this.attachments);
        }
        hessian2Output.flushBuffer();
        return outputStream.toByteArray();
    }

    public static DubboRequestBody decodeRequestBody(ByteBuf requestBodyBuf) throws IOException {
        ByteBufInputStream inputStream = null;
        try {
            Object[] args;
            Class[] pts;
            inputStream = new ByteBufInputStream(requestBodyBuf, true);
            Hessian2Input hessian2Input = new Hessian2Input((InputStream)inputStream);
            hessian2Input.setSerializerFactory(SERIALIZER_FACTORY);
            DubboRequestBody requestBody = new DubboRequestBody();
            requestBody.setDubboProtocolVersion(hessian2Input.readString());
            requestBody.setPath(hessian2Input.readString());
            requestBody.setVersion(hessian2Input.readString());
            requestBody.setMethodName(hessian2Input.readString());
            String serviceName = requestBody.getPath();
            String methodName = requestBody.getMethodName();
            RpcMethodInfo rpcMethodInfo = ServiceManager.getInstance().getService(serviceName, methodName);
            if (rpcMethodInfo == null) {
                throw new RpcException(3, "service not found, serviceName:" + serviceName + ", methodName:{}" + methodName);
            }
            requestBody.setRpcMethodInfo(rpcMethodInfo);
            Type[] inputTypes = rpcMethodInfo.getInputClasses();
            String desc = hessian2Input.readString();
            if (desc.length() == 0) {
                pts = new Class[]{};
                args = new Object[]{};
            } else {
                pts = new Class[inputTypes.length];
                args = new Object[inputTypes.length];
                for (int i = 0; i < args.length; ++i) {
                    try {
                        pts[i] = (Class)inputTypes[i];
                        args[i] = hessian2Input.readObject(pts[i]);
                        continue;
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn("Decode argument failed: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            requestBody.setParameterTypes(pts);
            requestBody.setArguments(args);
            Map map = (Map)hessian2Input.readObject(Map.class);
            if (map != null && map.size() > 0) {
                requestBody.getAttachments().putAll(map);
            }
            DubboRequestBody dubboRequestBody = requestBody;
            return dubboRequestBody;
        }
        catch (Exception e) {
            throw new IOException("Read invocation data failed.", e);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public void setDubboProtocolVersion(String dubboProtocolVersion) {
        this.dubboProtocolVersion = dubboProtocolVersion;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public void setAttachments(Map<String, String> attachments) {
        this.attachments = attachments;
    }

    public void setRpcMethodInfo(RpcMethodInfo rpcMethodInfo) {
        this.rpcMethodInfo = rpcMethodInfo;
    }

    public String getDubboProtocolVersion() {
        return this.dubboProtocolVersion;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public RpcMethodInfo getRpcMethodInfo() {
        return this.rpcMethodInfo;
    }
}

