/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.dubbo;

import com.alibaba.com.caucho.hessian.io.Hessian2Input;
import com.alibaba.com.caucho.hessian.io.Hessian2Output;
import com.baidu.brpc.protocol.dubbo.DubboConstants;
import com.baidu.brpc.protocol.dubbo.DubboRequestBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class DubboResponseBody {
    private byte responseType;
    private Object result = null;
    private Throwable exception = null;
    private Map<String, String> attachments;

    public byte[] encodeResponseBody() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);
        Hessian2Output hessian2Output = new Hessian2Output((OutputStream)outputStream);
        hessian2Output.setSerializerFactory(DubboRequestBody.SERIALIZER_FACTORY);
        hessian2Output.writeInt((int)this.responseType);
        hessian2Output.writeObject(this.result);
        if (this.attachments != null && this.attachments.size() > 0) {
            hessian2Output.writeObject(this.attachments);
        }
        hessian2Output.flush();
        return outputStream.toByteArray();
    }

    public static byte[] encodeErrorResponseBody(String errorMessage) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Hessian2Output hessian2Output = new Hessian2Output((OutputStream)outputStream);
        hessian2Output.setSerializerFactory(DubboRequestBody.SERIALIZER_FACTORY);
        hessian2Output.writeString(errorMessage);
        hessian2Output.flush();
        byte[] bodyBytes = outputStream.toByteArray();
        return bodyBytes;
    }

    public static byte[] encodeHeartbeatResponseBody() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Hessian2Output hessian2Output = new Hessian2Output((OutputStream)outputStream);
        hessian2Output.setSerializerFactory(DubboRequestBody.SERIALIZER_FACTORY);
        hessian2Output.writeString(DubboConstants.HEARTBEAT_EVENT);
        hessian2Output.flush();
        byte[] bodyBytes = outputStream.toByteArray();
        return bodyBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DubboResponseBody decodeResponseBody(ByteBuf responseBodyBuf) throws IOException {
        ByteBufInputStream inputStream = null;
        try {
            inputStream = new ByteBufInputStream(responseBodyBuf, true);
            Hessian2Input hessian2Input = new Hessian2Input((InputStream)inputStream);
            hessian2Input.setSerializerFactory(DubboRequestBody.SERIALIZER_FACTORY);
            DubboResponseBody responseBody = new DubboResponseBody();
            responseBody.setResponseType((byte)hessian2Input.readInt());
            switch (responseBody.getResponseType()) {
                case 2: {
                    break;
                }
                case 1: {
                    responseBody.setResult(hessian2Input.readObject());
                    break;
                }
                case 0: {
                    responseBody.setException((Throwable)hessian2Input.readObject());
                    break;
                }
                case 5: {
                    Map map = (Map)hessian2Input.readObject(Map.class);
                    if (map == null || map.size() <= 0) break;
                    responseBody.setAttachments(map);
                    break;
                }
                case 4: {
                    responseBody.setResult(hessian2Input.readObject());
                    Map map = (Map)hessian2Input.readObject(Map.class);
                    if (map == null || map.size() <= 0) break;
                    responseBody.setAttachments(map);
                    break;
                }
                case 3: {
                    responseBody.setException((Throwable)hessian2Input.readObject());
                    Map map = (Map)hessian2Input.readObject(Map.class);
                    if (map == null || map.size() <= 0) break;
                    responseBody.setAttachments(map);
                    break;
                }
            }
            DubboResponseBody dubboResponseBody = responseBody;
            return dubboResponseBody;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public void setResponseType(byte responseType) {
        this.responseType = responseType;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setAttachments(Map<String, String> attachments) {
        this.attachments = attachments;
    }

    public byte getResponseType() {
        return this.responseType;
    }

    public Object getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Map<String, String> getAttachments() {
        return this.attachments;
    }
}

