/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.http;

import com.baidu.brpc.CommunicationSpiManager;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.protocol.HttpResponse;
import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.protocol.ProtocolManager;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.http.HttpRpcProtocol;
import com.baidu.brpc.server.ServiceManager;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRpcServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRpcServlet.class);

    public void registerService(Object service) {
        ServiceManager serviceManager = ServiceManager.getInstance();
        serviceManager.registerService(service, null);
    }

    public void registerService(Class targetClass, Object service) {
        ServiceManager serviceManager = ServiceManager.getInstance();
        serviceManager.registerService(targetClass, service, null);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        byte[] content;
        long startTime = System.nanoTime();
        String requestUri = req.getRequestURI();
        if (requestUri == null) {
            LOG.warn("invalid request");
            resp.setStatus(404);
            return;
        }
        String encoding = req.getCharacterEncoding();
        String contentType = req.getContentType().split(";")[0];
        contentType = contentType == null ? "application/baidu.json-rpc" : contentType.toLowerCase();
        byte[] bytes = this.readStream((InputStream)req.getInputStream(), req.getContentLength());
        DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, requestUri);
        httpRequest.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        httpRequest.content().writeBytes(bytes);
        int protocolType = HttpRpcProtocol.parseProtocolType(contentType);
        CommunicationSpiManager.getInstance().loadAllExtensions(encoding);
        Protocol protocol = ProtocolManager.getInstance().getProtocol(protocolType);
        Request request = null;
        HttpResponse response = new HttpResponse();
        String errorMsg = null;
        try {
            request = protocol.decodeRequest(httpRequest);
            Object result = request.getTargetMethod().invoke(request.getTarget(), request.getArgs());
            response.setResult(result);
            response.setRpcMethodInfo(request.getRpcMethodInfo());
            response.setLogId(request.getLogId());
            response.setCorrelationId(request.getCorrelationId());
            protocol.encodeResponse(request, response);
        }
        catch (Exception ex) {
            errorMsg = String.format("invoke method failed, msg=%s", ex.getMessage());
            LOG.error(errorMsg);
            response.setException(new RpcException(3, errorMsg));
        }
        resp.setContentType(contentType);
        resp.setCharacterEncoding(encoding);
        if (errorMsg == null) {
            content = ((HttpRpcProtocol)protocol).encodeResponseBody(protocolType, request, response);
            resp.setContentLength(content.length);
            resp.getOutputStream().write(content);
        } else {
            content = errorMsg.getBytes();
            resp.setContentLength(content.length);
            resp.getOutputStream().write(content);
        }
        if (request != null) {
            long endTime = System.nanoTime();
            LOG.debug("uri={} logId={} service={} method={} elapseNs={}", new Object[]{requestUri, request.getLogId(), request.getTarget().getClass().getSimpleName(), request.getTargetMethod().getName(), endTime - startTime});
        }
    }

    private byte[] readStream(InputStream input, int length) throws IOException {
        int bytesRead;
        byte[] bytes = new byte[length];
        for (int offset = 0; offset < bytes.length && (bytesRead = input.read(bytes, offset, bytes.length - offset)) != -1; offset += bytesRead) {
        }
        return bytes;
    }
}

