/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server;

import com.baidu.brpc.server.ChannelStoreManager;
import com.baidu.brpc.server.push.PushChannelContextHolder;
import io.netty.channel.Channel;
import io.netty.util.Attribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannelStoreManager
implements ChannelStoreManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultChannelStoreManager.class);
    private Map<String, List<Channel>> channelMap = new HashMap<String, List<Channel>>();
    private Set<Channel> channelSet = new HashSet<Channel>();
    private AtomicInteger index = new AtomicInteger(0);

    @Override
    public void putChannel(String clientName, Channel channel) {
        if (!this.channelSet.contains(channel)) {
            List<Channel> channelList = this.channelMap.get(clientName);
            if (channelList == null) {
                channelList = new ArrayList<Channel>();
                this.channelMap.put(clientName, channelList);
            }
            this.channelMap.get(clientName).add(channel);
        }
    }

    @Override
    public Channel getChannel(String clientName) {
        List<Channel> channelList = this.channelMap.get(clientName);
        if (channelList == null || channelList.size() == 0) {
            log.info("no available connection for clientName={}", (Object)clientName);
            return null;
        }
        int id = this.index.getAndIncrement() % channelList.size();
        Channel channel = channelList.get(id);
        return channel;
    }

    @Override
    public void removeChannel(Channel channel) {
        Attribute participant = channel.attr(PushChannelContextHolder.CLIENTNAME_KEY);
        String participantName = (String)participant.get();
        List<Channel> channelList = this.channelMap.get(participantName);
        channelList.remove(channel);
        this.channelSet.remove(channel);
    }

    @Override
    public Map<String, List<Channel>> getChannelMap() {
        return this.channelMap;
    }
}

