/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server.handler;

import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.http.BrpcHttpResponseEncoder;
import com.baidu.brpc.protocol.http.HttpRpcProtocol;
import com.baidu.brpc.protocol.push.SPHead;
import com.baidu.brpc.protocol.push.ServerPushPacket;
import com.baidu.brpc.protocol.push.ServerPushProtocol;
import com.baidu.brpc.server.CommunicationServer;
import com.baidu.brpc.server.ServerStatus;
import com.baidu.brpc.server.handler.ServerWorkTask;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodeWorkTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DecodeWorkTask.class);
    private CommunicationServer rpcServer;
    private Object packet;
    private Protocol protocol;
    private ChannelHandlerContext ctx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block22: {
            SPHead spHead;
            if (this.protocol instanceof HttpRpcProtocol) {
                FullHttpRequest fullHttpRequest = (FullHttpRequest)this.packet;
                try {
                    if (fullHttpRequest.uri().equals("/favicon.ico")) {
                        DefaultFullHttpResponse fullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                        fullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
                        if (HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest)) {
                            fullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                        }
                        BrpcHttpResponseEncoder encoder = new BrpcHttpResponseEncoder();
                        ByteBuf responseByteBuf = encoder.encode(fullHttpResponse);
                        ChannelFuture f = this.ctx.channel().writeAndFlush((Object)responseByteBuf);
                        if (!HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest)) {
                            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        }
                        return;
                    }
                    if (fullHttpRequest.uri().equals("/") || fullHttpRequest.uri().equals("/status")) {
                        ServerStatus serverStatus = this.rpcServer.getServerStatus();
                        byte[] statusBytes = serverStatus.toString().getBytes("UTF-8");
                        DefaultFullHttpResponse fullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])statusBytes));
                        fullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
                        fullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fullHttpResponse.content().readableBytes());
                        if (HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest)) {
                            fullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"keep-alive");
                        }
                        BrpcHttpResponseEncoder encoder = new BrpcHttpResponseEncoder();
                        ByteBuf responseByteBuf = encoder.encode(fullHttpResponse);
                        ChannelFuture f = this.ctx.channel().writeAndFlush((Object)responseByteBuf);
                        if (!HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest)) {
                            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        }
                        return;
                    }
                    break block22;
                }
                catch (Exception ex) {
                    log.warn("send status info response failed:", (Throwable)ex);
                    return;
                }
            }
            if (this.protocol instanceof ServerPushProtocol && (spHead = ((ServerPushPacket)this.packet).getSpHead()).getType() == 3) {
                this.processClientResponse();
                return;
            }
        }
        Request request = null;
        Response response = this.protocol.createResponse();
        try {
            request = this.protocol.decodeRequest(this.packet);
            if (request.isHeartbeat()) {
                log.debug("receive hearbeat event from {}", (Object)this.ctx.channel().remoteAddress().toString());
            }
        }
        catch (Exception ex) {
            log.warn("decode request failed:", (Throwable)ex);
            response.setException(ex);
        }
        finally {
            if (request != null && request.getException() != null) {
                response.setException(request.getException());
            }
        }
        if (request == null || response.getException() != null) {
            try {
                ByteBuf byteBuf = this.protocol.encodeResponse(request, response);
                ChannelFuture channelFuture = this.ctx.channel().writeAndFlush((Object)byteBuf);
                this.protocol.afterResponseSent(request, response, channelFuture);
            }
            catch (Exception ex) {
                log.warn("send response failed:", (Throwable)ex);
            }
            return;
        }
        ServerWorkTask workTask = new ServerWorkTask(this.rpcServer, this.protocol, request, response, this.ctx);
        if (request.isHeartbeat() || request.getRpcMethodInfo().getThreadPool() == this.rpcServer.getThreadPool()) {
            workTask.run();
        } else {
            request.getRpcMethodInfo().getThreadPool().submit(workTask);
        }
    }

    public void processClientResponse() {
        Response response;
        try {
            response = ((ServerPushProtocol)this.protocol).decodeServerPushResponse(this.packet, this.ctx);
        }
        catch (Exception e) {
            log.warn("decode response failed:", (Throwable)e);
            return;
        }
        if (response.getRpcFuture() != null) {
            log.debug("handle response, logId={}", (Object)response.getLogId());
            RpcFuture future = response.getRpcFuture();
            future.handleResponse(response);
        } else {
            log.warn("rpcFuture is null, logId={}", (Object)response.getLogId());
        }
    }

    public void setRpcServer(CommunicationServer rpcServer) {
        this.rpcServer = rpcServer;
    }

    public void setPacket(Object packet) {
        this.packet = packet;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public CommunicationServer getRpcServer() {
        return this.rpcServer;
    }

    public Object getPacket() {
        return this.packet;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public DecodeWorkTask(CommunicationServer rpcServer, Object packet, Protocol protocol, ChannelHandlerContext ctx) {
        this.rpcServer = rpcServer;
        this.packet = packet;
        this.protocol = protocol;
        this.ctx = ctx;
    }
}

