/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.thread;

import com.baidu.brpc.utils.BrpcConstants;
import com.baidu.brpc.utils.CustomThreadFactory;
import com.baidu.brpc.utils.ThreadPool;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrpcThreadPoolManager {
    private static final Logger log = LoggerFactory.getLogger(BrpcThreadPoolManager.class);
    private volatile EventLoopGroup defaultIoThreadPool;
    private ConcurrentMap<String, EventLoopGroup> ioThreadPoolMap = new ConcurrentHashMap<String, EventLoopGroup>();
    private volatile ThreadPool defaultWorkThreadPool;
    private ConcurrentMap<String, ThreadPool> workThreadPoolMap = new ConcurrentHashMap<String, ThreadPool>();
    private ExecutorService exceptionThreadPool = Executors.newFixedThreadPool(1, new CustomThreadFactory("exception-thread"));
    private static volatile BrpcThreadPoolManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BrpcThreadPoolManager getInstance() {
        if (instance != null) return instance;
        Class<BrpcThreadPoolManager> clazz = BrpcThreadPoolManager.class;
        synchronized (BrpcThreadPoolManager.class) {
            if (instance != null) return instance;
            instance = new BrpcThreadPoolManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EventLoopGroup getOrCreateClientIoThreadPool(String serviceName, boolean isSharing, int threadNum, int ioEventType) {
        if (isSharing) {
            if (this.defaultIoThreadPool != null) return this.defaultIoThreadPool;
            Class<BrpcThreadPoolManager> clazz = BrpcThreadPoolManager.class;
            synchronized (BrpcThreadPoolManager.class) {
                if (this.defaultIoThreadPool != null) return this.defaultIoThreadPool;
                this.defaultIoThreadPool = this.createClientIoThreadPool(threadNum, "brpc-client-io-thread-default", ioEventType);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return this.defaultIoThreadPool;
            }
        }
        EventLoopGroup threadPool = (EventLoopGroup)this.ioThreadPoolMap.get(serviceName);
        if (threadPool != null) return threadPool;
        String string = this.internalServiceName(serviceName).intern();
        synchronized (string) {
            EventLoopGroup prev;
            threadPool = (EventLoopGroup)this.ioThreadPoolMap.get(serviceName);
            if (threadPool != null || (prev = this.ioThreadPoolMap.putIfAbsent(serviceName, threadPool = this.createClientIoThreadPool(threadNum, "brpc-client-io-thread-" + serviceName, ioEventType))) == null) return threadPool;
            log.warn("brpc io thread pool exist for service:{}", (Object)serviceName);
            threadPool.shutdownGracefully().awaitUninterruptibly();
            return threadPool;
        }
    }

    protected EventLoopGroup createClientIoThreadPool(int threadNum, String namePrefix, int ioEventType) {
        Object eventLoopGroup = ioEventType == BrpcConstants.IO_EVENT_NETTY_EPOLL ? new EpollEventLoopGroup(threadNum, (ThreadFactory)new CustomThreadFactory(namePrefix)) : new NioEventLoopGroup(threadNum, (ThreadFactory)new CustomThreadFactory(namePrefix));
        return eventLoopGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ThreadPool getOrCreateClientWorkThreadPool(String serviceName, boolean isSharing, int threadNum) {
        if (isSharing) {
            if (this.defaultWorkThreadPool != null) return this.defaultWorkThreadPool;
            Class<BrpcThreadPoolManager> clazz = BrpcThreadPoolManager.class;
            synchronized (BrpcThreadPoolManager.class) {
                if (this.defaultWorkThreadPool != null) return this.defaultWorkThreadPool;
                this.defaultWorkThreadPool = new ThreadPool(threadNum, new CustomThreadFactory("brpc-client-work-thread-default"));
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return this.defaultWorkThreadPool;
            }
        }
        ThreadPool threadPool = (ThreadPool)this.workThreadPoolMap.get(serviceName);
        if (threadPool != null) return threadPool;
        String string = this.internalServiceName(serviceName).intern();
        synchronized (string) {
            threadPool = (ThreadPool)this.workThreadPoolMap.get(serviceName);
            if (threadPool != null) return threadPool;
            threadPool = new ThreadPool(threadNum, new CustomThreadFactory("brpc-client-work-thread-" + serviceName));
            this.workThreadPoolMap.put(serviceName, threadPool);
            return threadPool;
        }
    }

    protected String internalServiceName(String serviceName) {
        return this.getClass().getName() + ":" + serviceName;
    }

    public void stopAll() {
        Iterator iterator = this.ioThreadPoolMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ((EventLoopGroup)iterator.next().getValue()).shutdownGracefully().awaitUninterruptibly();
            iterator.remove();
        }
        Iterator iterator2 = this.workThreadPoolMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            ((ThreadPool)iterator2.next().getValue()).stop();
            iterator2.remove();
        }
        if (this.defaultIoThreadPool != null) {
            this.defaultIoThreadPool.shutdownGracefully().awaitUninterruptibly();
            this.defaultIoThreadPool = null;
        }
        if (this.exceptionThreadPool != null) {
            this.exceptionThreadPool.shutdownNow();
        }
    }

    public void stopServiceThreadPool(String serviceName) {
        ThreadPool workThreadPool;
        BrpcThreadPoolManager threadPoolManager = BrpcThreadPoolManager.getInstance();
        EventLoopGroup ioThreadPool = (EventLoopGroup)threadPoolManager.getIoThreadPoolMap().remove(serviceName);
        if (ioThreadPool != null) {
            ioThreadPool.shutdownGracefully().syncUninterruptibly();
        }
        if ((workThreadPool = (ThreadPool)threadPoolManager.getWorkThreadPoolMap().remove(serviceName)) != null) {
            workThreadPool.stop();
        }
    }

    public EventLoopGroup getDefaultIoThreadPool() {
        return this.defaultIoThreadPool;
    }

    public ConcurrentMap<String, EventLoopGroup> getIoThreadPoolMap() {
        return this.ioThreadPoolMap;
    }

    public ThreadPool getDefaultWorkThreadPool() {
        return this.defaultWorkThreadPool;
    }

    public ConcurrentMap<String, ThreadPool> getWorkThreadPoolMap() {
        return this.workThreadPoolMap;
    }

    public ExecutorService getExceptionThreadPool() {
        return this.exceptionThreadPool;
    }
}

