/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.utils;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pb2JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(Pb2JsonUtils.class);
    private static PbVersion pbVersion;
    private static JsonFormat pb2Converter;
    private static Class pb3PrinterClazz;
    private static Object pb3Printer;
    private static Method pb3PrintMethod;
    private static Class pb3ParserClazz;
    private static Object pb3Parser;
    private static Method pb3ParseMethod;

    public static void checkPbVersion() {
        if (Pb2JsonUtils.isClassExist("com.google.protobuf.MapField")) {
            pbVersion = PbVersion.PROTO3;
            try {
                Class<?> jsonFormatClazz = Class.forName("com.google.protobuf.util.JsonFormat");
                Method method = jsonFormatClazz.getMethod("printer", new Class[0]);
                pb3Printer = method.invoke(jsonFormatClazz, new Object[0]);
                pb3PrinterClazz = Class.forName("com.google.protobuf.util.JsonFormat$Printer");
                method = pb3PrinterClazz.getDeclaredMethod("includingDefaultValueFields", new Class[0]);
                method.invoke(pb3Printer, new Object[0]);
                pb3PrintMethod = pb3PrinterClazz.getDeclaredMethod("print", MessageOrBuilder.class);
                method = jsonFormatClazz.getMethod("parser", new Class[0]);
                pb3Parser = method.invoke(jsonFormatClazz, new Object[0]);
                pb3ParserClazz = Class.forName("com.google.protobuf.util.JsonFormat$Parser");
                method = pb3ParserClazz.getDeclaredMethod("ignoringUnknownFields", new Class[0]);
                method.invoke(pb3Parser, new Object[0]);
                pb3ParseMethod = pb3ParserClazz.getDeclaredMethod("merge", String.class, Message.Builder.class);
            }
            catch (Exception ex) {
                throw new RuntimeException("dependency of protobuf-java-util not exist");
            }
        } else {
            pbVersion = PbVersion.PROTO2;
            pb2Converter = new JsonFormat(){

                protected void print(Message message, JsonFormat.JsonGenerator generator) throws IOException {
                    Iterator iter = message.getAllFields().entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry field = iter.next();
                        this.printField((Descriptors.FieldDescriptor)field.getKey(), field.getValue(), generator);
                        if (!iter.hasNext()) continue;
                        generator.print((CharSequence)",");
                    }
                }
            };
        }
    }

    public static void json2Pb(CharSequence input, Message.Builder builder) throws JsonFormat.ParseException {
        if (pbVersion == PbVersion.PROTO2) {
            pb2Converter.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
        } else {
            try {
                pb3ParseMethod.invoke(pb3Parser, input, builder);
            }
            catch (Exception ex) {
                log.warn("pb3 json2pb failed, ex:", (Throwable)ex);
            }
        }
    }

    public static String pb2json(Message message, String encoding) throws IOException {
        if (pbVersion == PbVersion.PROTO2) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            pb2Converter.print(message, (OutputStream)out, Charset.forName(encoding));
            out.flush();
            return out.toString(encoding);
        }
        try {
            return (String)pb3PrintMethod.invoke(pb3Printer, message);
        }
        catch (Exception ex) {
            log.warn("pb3 pb2json failed, ex:", (Throwable)ex);
            return null;
        }
    }

    public static boolean isClassExist(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    static {
        Pb2JsonUtils.checkPbVersion();
    }

    public static enum PbVersion {
        PROTO2,
        PROTO3;

    }
}

