/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.utils;

import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.annotation.ProtobufClass;
import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.google.protobuf.Message;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufUtils {
    private static final Logger log = LoggerFactory.getLogger(ProtobufUtils.class);

    public static MessageType getMessageType(Method method) {
        Field[] fields;
        Class<?>[] types = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        if (types.length < 0) {
            throw new IllegalArgumentException("invalid rpc method params");
        }
        if (types.length != 1) {
            return MessageType.POJO;
        }
        Class<?> inputType = types[0];
        if (Message.class.isAssignableFrom(inputType) && Message.class.isAssignableFrom(returnType)) {
            return MessageType.PROTOBUF;
        }
        ProtobufClass protobufClass = inputType.getAnnotation(ProtobufClass.class);
        if (protobufClass != null) {
            return MessageType.JPROTOBUF;
        }
        for (Field field : fields = inputType.getDeclaredFields()) {
            Protobuf protobuf = field.getAnnotation(Protobuf.class);
            if (protobuf == null) continue;
            return MessageType.JPROTOBUF;
        }
        return MessageType.POJO;
    }

    public static Message parseFrom(InputStream inputStream, Class clazz) {
        try {
            Method method = clazz.getMethod("getDefaultInstance", new Class[0]);
            Message proto = (Message)method.invoke(null, new Object[0]);
            proto = proto.newBuilderForType().mergeFrom(inputStream).build();
            return proto;
        }
        catch (Exception ex) {
            String errorMsg = String.format("parse proto failed, msg=%s", ex.getMessage());
            log.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
    }

    public static Message parseFrom(byte[] inputBytes, Class clazz) {
        try {
            Method method = clazz.getMethod("parseFrom", byte[].class);
            Message proto = (Message)method.invoke(null, new Object[]{inputBytes});
            return proto;
        }
        catch (Exception ex) {
            String errorMsg = String.format("parse proto failed, msg=%s", ex.getMessage());
            log.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
    }

    public static Message parseFrom(ByteBuf input, Message defaultInstance) throws IOException {
        int length = input.readableBytes();
        byte[] array = new byte[length];
        input.readBytes(array, 0, length);
        return (Message)defaultInstance.getParserForType().parseFrom(array);
    }

    public static Message parseFrom(byte[] input, Message defaultInstance) throws IOException {
        return (Message)defaultInstance.getParserForType().parseFrom(input);
    }

    public static Message parseFrom(DynamicCompositeByteBuf input, Message defaultInstance) throws IOException {
        int length = input.readableBytes();
        byte[] array = new byte[length];
        input.readBytes(array, 0, length);
        int offset = 0;
        return (Message)defaultInstance.getParserForType().parseFrom(array, offset, length);
    }

    public static enum MessageType {
        PROTOBUF,
        JPROTOBUF,
        POJO;

    }
}

