/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.request.body;

import com.baidu.cloud.thirdparty.asynchttpclient.request.body.RandomAccessBody;
import com.baidu.cloud.thirdparty.asynchttpclient.util.Assertions;
import com.baidu.cloud.thirdparty.asynchttpclient.util.MiscUtils;
import com.baidu.cloud.thirdparty.netty.channel.FileRegion;
import com.baidu.cloud.thirdparty.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

class BodyFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private final RandomAccessBody body;
    private long transferred;

    BodyFileRegion(RandomAccessBody body) {
        this.body = Assertions.assertNotNull(body, "body");
    }

    @Override
    public long position() {
        return 0L;
    }

    @Override
    public long count() {
        return this.body.getContentLength();
    }

    @Override
    public long transfered() {
        return this.transferred();
    }

    @Override
    public long transferred() {
        return this.transferred;
    }

    @Override
    public FileRegion retain() {
        super.retain();
        return this;
    }

    @Override
    public FileRegion retain(int arg0) {
        super.retain(arg0);
        return this;
    }

    @Override
    public FileRegion touch() {
        return this;
    }

    @Override
    public FileRegion touch(Object arg0) {
        return this;
    }

    @Override
    public long transferTo(WritableByteChannel target, long position) throws IOException {
        long written = this.body.transferTo(target);
        if (written > 0L) {
            this.transferred += written;
        }
        return written;
    }

    @Override
    protected void deallocate() {
        MiscUtils.closeSilently(this.body);
    }
}

