/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.request.body;

import com.baidu.cloud.thirdparty.asynchttpclient.AsyncHttpClientConfig;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.NettyResponseFuture;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.ChannelManager;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.WriteProgressListener;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.body.BodyChunkedInput;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.body.BodyFileRegion;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.body.NettyBody;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.Body;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.RandomAccessBody;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.generator.BodyGenerator;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.generator.FeedListener;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.generator.ReactiveStreamsBodyGenerator;
import com.baidu.cloud.thirdparty.asynchttpclient.util.MiscUtils;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.channel.ChannelProgressiveFuture;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.LastHttpContent;
import com.baidu.cloud.thirdparty.netty.handler.stream.ChunkedWriteHandler;

public class NettyBodyBody
implements NettyBody {
    private final Body body;
    private final AsyncHttpClientConfig config;

    public NettyBodyBody(Body body, AsyncHttpClientConfig config) {
        this.body = body;
        this.config = config;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public long getContentLength() {
        return this.body.getContentLength();
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) {
        Object msg;
        if (this.body instanceof RandomAccessBody && !ChannelManager.isSslHandlerConfigured(channel.pipeline()) && !this.config.isDisableZeroCopy() && this.getContentLength() > 0L) {
            msg = new BodyFileRegion((RandomAccessBody)this.body);
        } else {
            msg = new BodyChunkedInput(this.body);
            BodyGenerator bg = future.getTargetRequest().getBodyGenerator();
            if (bg instanceof FeedableBodyGenerator && !(bg instanceof ReactiveStreamsBodyGenerator)) {
                final ChunkedWriteHandler chunkedWriteHandler = channel.pipeline().get(ChunkedWriteHandler.class);
                ((FeedableBodyGenerator)FeedableBodyGenerator.class.cast(bg)).setListener(new FeedListener(){

                    @Override
                    public void onContentAdded() {
                        chunkedWriteHandler.resumeTransfer();
                    }

                    @Override
                    public void onError(Throwable t) {
                    }
                });
            }
        }
        channel.write(msg, channel.newProgressivePromise()).addListener(new WriteProgressListener(future, false, this.getContentLength()){

            @Override
            public void operationComplete(ChannelProgressiveFuture cf) {
                MiscUtils.closeSilently(NettyBodyBody.this.body);
                super.operationComplete(cf);
            }
        });
        channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT, channel.voidPromise());
    }
}

