/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.dyuprotostuff;

import com.baidu.cloud.thirdparty.dyuprotostuff.LinkedBuffer;
import com.baidu.cloud.thirdparty.dyuprotostuff.WriteSink;
import java.io.OutputStream;

public class WriteSession {
    public final LinkedBuffer head;
    protected LinkedBuffer tail;
    protected int size = 0;
    public final int nextBufferSize;
    public final OutputStream out;
    public final WriteSink sink;

    public WriteSession(LinkedBuffer head) {
        this(head, 512);
    }

    public WriteSession(LinkedBuffer head, int nextBufferSize) {
        this.tail = head;
        this.head = head;
        this.nextBufferSize = nextBufferSize;
        this.out = null;
        this.sink = WriteSink.BUFFERED;
    }

    public WriteSession(LinkedBuffer head, OutputStream out) {
        this.tail = head;
        this.head = head;
        this.nextBufferSize = 512;
        this.out = out;
        this.sink = WriteSink.STREAMED;
        assert (out != null);
    }

    public WriteSession clear() {
        this.tail = this.head.clear();
        this.size = 0;
        return this;
    }

    public final int getSize() {
        return this.size;
    }

    public final byte[] toByteArray() {
        LinkedBuffer node = this.head;
        int offset = 0;
        byte[] buf = new byte[this.size];
        do {
            int len;
            if ((len = node.offset - node.start) <= 0) continue;
            System.arraycopy(node.buffer, node.start, buf, offset, len);
            offset += len;
        } while ((node = node.next) != null);
        return buf;
    }
}

