/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.aop.support;

import com.baidu.cloud.thirdparty.springframework.aop.DynamicIntroductionAdvice;
import com.baidu.cloud.thirdparty.springframework.aop.IntroductionInterceptor;
import com.baidu.cloud.thirdparty.springframework.aop.ProxyMethodInvocation;
import com.baidu.cloud.thirdparty.springframework.aop.support.AopUtils;
import com.baidu.cloud.thirdparty.springframework.aop.support.IntroductionInfoSupport;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import org.aopalliance.intercept.MethodInvocation;

public class DelegatingIntroductionInterceptor
extends IntroductionInfoSupport
implements IntroductionInterceptor {
    @Nullable
    private Object delegate;

    public DelegatingIntroductionInterceptor(Object delegate) {
        this.init(delegate);
    }

    protected DelegatingIntroductionInterceptor() {
        this.init(this);
    }

    private void init(Object delegate) {
        Assert.notNull(delegate, "Delegate must not be null");
        this.delegate = delegate;
        this.implementInterfacesOnObject(delegate);
        this.suppressInterface(IntroductionInterceptor.class);
        this.suppressInterface(DynamicIntroductionAdvice.class);
    }

    @Override
    @Nullable
    public Object invoke(MethodInvocation mi) throws Throwable {
        if (this.isMethodOnIntroducedInterface(mi)) {
            Object retVal = AopUtils.invokeJoinpointUsingReflection(this.delegate, mi.getMethod(), mi.getArguments());
            if (retVal == this.delegate && mi instanceof ProxyMethodInvocation) {
                Object proxy = ((ProxyMethodInvocation)mi).getProxy();
                if (mi.getMethod().getReturnType().isInstance(proxy)) {
                    retVal = proxy;
                }
            }
            return retVal;
        }
        return this.doProceed(mi);
    }

    protected Object doProceed(MethodInvocation mi) throws Throwable {
        return mi.proceed();
    }
}

