/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.beans.factory.config;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.beans.BeansException;
import com.baidu.cloud.thirdparty.springframework.beans.PropertyEditorRegistrar;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanFactoryPostProcessor;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.baidu.cloud.thirdparty.springframework.core.Ordered;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import java.beans.PropertyEditor;
import java.util.Map;

public class CustomEditorConfigurer
implements BeanFactoryPostProcessor,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    @Nullable
    private PropertyEditorRegistrar[] propertyEditorRegistrars;
    @Nullable
    private Map<Class<?>, Class<? extends PropertyEditor>> customEditors;

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setPropertyEditorRegistrars(PropertyEditorRegistrar[] propertyEditorRegistrars) {
        this.propertyEditorRegistrars = propertyEditorRegistrars;
    }

    public void setCustomEditors(Map<Class<?>, Class<? extends PropertyEditor>> customEditors) {
        this.customEditors = customEditors;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.propertyEditorRegistrars != null) {
            for (PropertyEditorRegistrar propertyEditorRegistrar : this.propertyEditorRegistrars) {
                beanFactory.addPropertyEditorRegistrar(propertyEditorRegistrar);
            }
        }
        if (this.customEditors != null) {
            this.customEditors.forEach(beanFactory::registerCustomEditor);
        }
    }
}

