/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.beans.factory.config;

import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanExpressionContext;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanExpressionResolver;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.StringValueResolver;

public class EmbeddedValueResolver
implements StringValueResolver {
    private final BeanExpressionContext exprContext;
    @Nullable
    private final BeanExpressionResolver exprResolver;

    public EmbeddedValueResolver(ConfigurableBeanFactory beanFactory) {
        this.exprContext = new BeanExpressionContext(beanFactory, null);
        this.exprResolver = beanFactory.getBeanExpressionResolver();
    }

    @Override
    @Nullable
    public String resolveStringValue(String strVal) {
        String value = this.exprContext.getBeanFactory().resolveEmbeddedValue(strVal);
        if (this.exprResolver != null && value != null) {
            Object evaluated = this.exprResolver.evaluate(value, this.exprContext);
            value = evaluated != null ? evaluated.toString() : null;
        }
        return value;
    }
}

