/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.beans.factory.config;

import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanDefinitionStoreException;
import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PreferencesPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements InitializingBean {
    @Nullable
    private String systemTreePath;
    @Nullable
    private String userTreePath;
    private Preferences systemPrefs = Preferences.systemRoot();
    private Preferences userPrefs = Preferences.userRoot();

    public void setSystemTreePath(String systemTreePath) {
        this.systemTreePath = systemTreePath;
    }

    public void setUserTreePath(String userTreePath) {
        this.userTreePath = userTreePath;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.systemTreePath != null) {
            this.systemPrefs = this.systemPrefs.node(this.systemTreePath);
        }
        if (this.userTreePath != null) {
            this.userPrefs = this.userPrefs.node(this.userTreePath);
        }
    }

    @Override
    protected String resolvePlaceholder(String placeholder, Properties props) {
        String value;
        String path = null;
        String key = placeholder;
        int endOfPath = placeholder.lastIndexOf(47);
        if (endOfPath != -1) {
            path = placeholder.substring(0, endOfPath);
            key = placeholder.substring(endOfPath + 1);
        }
        if ((value = this.resolvePlaceholder(path, key, this.userPrefs)) == null && (value = this.resolvePlaceholder(path, key, this.systemPrefs)) == null) {
            value = props.getProperty(placeholder);
        }
        return value;
    }

    @Nullable
    protected String resolvePlaceholder(@Nullable String path, String key, Preferences preferences) {
        if (path != null) {
            try {
                if (preferences.nodeExists(path)) {
                    return preferences.node(path).get(key, null);
                }
                return null;
            }
            catch (BackingStoreException ex) {
                throw new BeanDefinitionStoreException("Cannot access specified node path [" + path + "]", ex);
            }
        }
        return preferences.get(key, null);
    }
}

