/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.beans.factory.support;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanDefinitionStoreException;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.BeanDefinitionReader;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.BeanNameGenerator;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.DefaultBeanNameGenerator;
import com.baidu.cloud.thirdparty.springframework.core.env.Environment;
import com.baidu.cloud.thirdparty.springframework.core.env.EnvironmentCapable;
import com.baidu.cloud.thirdparty.springframework.core.env.StandardEnvironment;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.core.io.ResourceLoader;
import com.baidu.cloud.thirdparty.springframework.core.io.support.PathMatchingResourcePatternResolver;
import com.baidu.cloud.thirdparty.springframework.core.io.support.ResourcePatternResolver;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.io.IOException;
import java.util.Set;

public abstract class AbstractBeanDefinitionReader
implements EnvironmentCapable,
BeanDefinitionReader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final BeanDefinitionRegistry registry;
    @Nullable
    private ResourceLoader resourceLoader;
    @Nullable
    private ClassLoader beanClassLoader;
    private Environment environment;
    private BeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();

    protected AbstractBeanDefinitionReader(BeanDefinitionRegistry registry) {
        Assert.notNull((Object)registry, "BeanDefinitionRegistry must not be null");
        this.registry = registry;
        this.resourceLoader = this.registry instanceof ResourceLoader ? (ResourceLoader)((Object)this.registry) : new PathMatchingResourcePatternResolver();
        this.environment = this.registry instanceof EnvironmentCapable ? ((EnvironmentCapable)((Object)this.registry)).getEnvironment() : new StandardEnvironment();
    }

    public final BeanDefinitionRegistry getBeanFactory() {
        return this.registry;
    }

    @Override
    public final BeanDefinitionRegistry getRegistry() {
        return this.registry;
    }

    public void setResourceLoader(@Nullable ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    @Nullable
    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setBeanClassLoader(@Nullable ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    @Nullable
    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setEnvironment(Environment environment2) {
        Assert.notNull((Object)environment2, "Environment must not be null");
        this.environment = environment2;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    public void setBeanNameGenerator(@Nullable BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator != null ? beanNameGenerator : new DefaultBeanNameGenerator();
    }

    @Override
    public BeanNameGenerator getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    @Override
    public int loadBeanDefinitions(Resource ... resources) throws BeanDefinitionStoreException {
        Assert.notNull((Object)resources, "Resource array must not be null");
        int counter = 0;
        for (Resource resource : resources) {
            counter += this.loadBeanDefinitions(resource);
        }
        return counter;
    }

    @Override
    public int loadBeanDefinitions(String location) throws BeanDefinitionStoreException {
        return this.loadBeanDefinitions(location, (Set<Resource>)null);
    }

    public int loadBeanDefinitions(String location, @Nullable Set<Resource> actualResources) throws BeanDefinitionStoreException {
        ResourceLoader resourceLoader = this.getResourceLoader();
        if (resourceLoader == null) {
            throw new BeanDefinitionStoreException("Cannot import bean definitions from location [" + location + "]: no ResourceLoader available");
        }
        if (resourceLoader instanceof ResourcePatternResolver) {
            try {
                Resource[] resources = ((ResourcePatternResolver)resourceLoader).getResources(location);
                int loadCount = this.loadBeanDefinitions(resources);
                if (actualResources != null) {
                    for (Resource resource : resources) {
                        actualResources.add(resource);
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loaded " + loadCount + " bean definitions from location pattern [" + location + "]");
                }
                return loadCount;
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Could not resolve bean definition resource pattern [" + location + "]", ex);
            }
        }
        Resource resource = resourceLoader.getResource(location);
        int loadCount = this.loadBeanDefinitions(resource);
        if (actualResources != null) {
            actualResources.add(resource);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loaded " + loadCount + " bean definitions from location [" + location + "]");
        }
        return loadCount;
    }

    @Override
    public int loadBeanDefinitions(String ... locations) throws BeanDefinitionStoreException {
        Assert.notNull((Object)locations, "Location array must not be null");
        int counter = 0;
        for (String location : locations) {
            counter += this.loadBeanDefinitions(location);
        }
        return counter;
    }
}

