/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.beans.support;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.beans.BeanWrapperImpl;
import com.baidu.cloud.thirdparty.springframework.beans.BeansException;
import com.baidu.cloud.thirdparty.springframework.beans.support.MutableSortDefinition;
import com.baidu.cloud.thirdparty.springframework.beans.support.SortDefinition;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class PropertyComparator<T>
implements Comparator<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final SortDefinition sortDefinition;
    private final BeanWrapperImpl beanWrapper = new BeanWrapperImpl(false);

    public PropertyComparator(SortDefinition sortDefinition) {
        this.sortDefinition = sortDefinition;
    }

    public PropertyComparator(String property, boolean ignoreCase, boolean ascending) {
        this.sortDefinition = new MutableSortDefinition(property, ignoreCase, ascending);
    }

    public final SortDefinition getSortDefinition() {
        return this.sortDefinition;
    }

    @Override
    public int compare(T o1, T o2) {
        int result;
        Object v1 = this.getPropertyValue(o1);
        Object v2 = this.getPropertyValue(o2);
        if (this.sortDefinition.isIgnoreCase() && v1 instanceof String && v2 instanceof String) {
            v1 = ((String)v1).toLowerCase();
            v2 = ((String)v2).toLowerCase();
        }
        try {
            result = v1 != null ? (v2 != null ? ((Comparable)v1).compareTo(v2) : -1) : (v2 != null ? 1 : 0);
        }
        catch (RuntimeException ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Could not sort objects [" + o1 + "] and [" + o2 + "]", ex);
            }
            return 0;
        }
        return this.sortDefinition.isAscending() ? result : -result;
    }

    @Nullable
    private Object getPropertyValue(Object obj) {
        try {
            this.beanWrapper.setWrappedInstance(obj);
            return this.beanWrapper.getPropertyValue(this.sortDefinition.getProperty());
        }
        catch (BeansException ex) {
            this.logger.info("PropertyComparator could not access property - treating as null for sorting", ex);
            return null;
        }
    }

    public static void sort(List<?> source, SortDefinition sortDefinition) throws BeansException {
        if (StringUtils.hasText(sortDefinition.getProperty())) {
            source.sort(new PropertyComparator(sortDefinition));
        }
    }

    public static void sort(Object[] source, SortDefinition sortDefinition) throws BeansException {
        if (StringUtils.hasText(sortDefinition.getProperty())) {
            Arrays.sort(source, new PropertyComparator(sortDefinition));
        }
    }
}

