/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.cache.interceptor;

import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.cache.Cache;
import com.baidu.cloud.thirdparty.springframework.cache.CacheManager;
import com.baidu.cloud.thirdparty.springframework.cache.interceptor.CacheOperationInvocationContext;
import com.baidu.cloud.thirdparty.springframework.cache.interceptor.CacheResolver;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractCacheResolver
implements CacheResolver,
InitializingBean {
    @Nullable
    private CacheManager cacheManager;

    protected AbstractCacheResolver() {
    }

    protected AbstractCacheResolver(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        Assert.state(this.cacheManager != null, "No CacheManager set");
        return this.cacheManager;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull((Object)this.cacheManager, "CacheManager is required");
    }

    @Override
    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        Collection<String> cacheNames = this.getCacheNames(context);
        if (cacheNames == null) {
            return Collections.emptyList();
        }
        ArrayList<Cache> result = new ArrayList<Cache>(cacheNames.size());
        for (String cacheName : cacheNames) {
            Cache cache = this.getCacheManager().getCache(cacheName);
            if (cache == null) {
                throw new IllegalArgumentException("Cannot find cache named '" + cacheName + "' for " + context.getOperation());
            }
            result.add(cache);
        }
        return result;
    }

    @Nullable
    protected abstract Collection<String> getCacheNames(CacheOperationInvocationContext<?> var1);
}

