/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.context.annotation;

import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanDefinitionCustomizer;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.BeanNameGenerator;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.DefaultListableBeanFactory;
import com.baidu.cloud.thirdparty.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import com.baidu.cloud.thirdparty.springframework.context.annotation.AnnotationConfigRegistry;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ScopeMetadataResolver;
import com.baidu.cloud.thirdparty.springframework.context.support.GenericApplicationContext;
import com.baidu.cloud.thirdparty.springframework.core.env.ConfigurableEnvironment;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.util.function.Supplier;

public class AnnotationConfigApplicationContext
extends GenericApplicationContext
implements AnnotationConfigRegistry {
    private final AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(this);
    private final ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(this);

    public AnnotationConfigApplicationContext() {
    }

    public AnnotationConfigApplicationContext(DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    public AnnotationConfigApplicationContext(Class<?> ... annotatedClasses) {
        this();
        this.register(annotatedClasses);
        this.refresh();
    }

    public AnnotationConfigApplicationContext(String ... basePackages) {
        this();
        this.scan(basePackages);
        this.refresh();
    }

    @Override
    public void setEnvironment(ConfigurableEnvironment environment2) {
        super.setEnvironment(environment2);
        this.reader.setEnvironment(environment2);
        this.scanner.setEnvironment(environment2);
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.reader.setBeanNameGenerator(beanNameGenerator);
        this.scanner.setBeanNameGenerator(beanNameGenerator);
        this.getBeanFactory().registerSingleton("com.baidu.cloud.thirdparty.springframework.context.annotation.internalConfigurationBeanNameGenerator", beanNameGenerator);
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.reader.setScopeMetadataResolver(scopeMetadataResolver);
        this.scanner.setScopeMetadataResolver(scopeMetadataResolver);
    }

    @Override
    public void register(Class<?> ... annotatedClasses) {
        Assert.notEmpty((Object[])annotatedClasses, "At least one annotated class must be specified");
        this.reader.register(annotatedClasses);
    }

    @Override
    public void scan(String ... basePackages) {
        Assert.notEmpty((Object[])basePackages, "At least one base package must be specified");
        this.scanner.scan(basePackages);
    }

    public <T> void registerBean(Class<T> annotatedClass, Object ... constructorArguments) {
        this.registerBean(null, annotatedClass, constructorArguments);
    }

    public <T> void registerBean(@Nullable String beanName, Class<T> annotatedClass, Object ... constructorArguments) {
        this.reader.doRegisterBean(annotatedClass, null, beanName, null, bd -> {
            for (Object arg : constructorArguments) {
                bd.getConstructorArgumentValues().addGenericArgumentValue(arg);
            }
        });
    }

    @Override
    public <T> void registerBean(@Nullable String beanName, Class<T> beanClass, @Nullable Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
        this.reader.doRegisterBean(beanClass, supplier, beanName, null, customizers);
    }
}

