/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.context.annotation;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.springframework.aop.config.AopConfigUtils;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.baidu.cloud.thirdparty.springframework.context.annotation.AdviceMode;
import com.baidu.cloud.thirdparty.springframework.context.annotation.AnnotationConfigUtils;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAttributes;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotatedTypeMetadata;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotationMetadata;
import java.util.Set;

public class AutoProxyRegistrar
implements ImportBeanDefinitionRegistrar {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        boolean candidateFound = false;
        Set<String> annoTypes = importingClassMetadata.getAnnotationTypes();
        for (String annoType : annoTypes) {
            AnnotationAttributes candidate = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)importingClassMetadata, annoType);
            if (candidate == null) continue;
            Object mode = candidate.get("mode");
            Object proxyTargetClass = candidate.get("proxyTargetClass");
            if (mode == null || proxyTargetClass == null || AdviceMode.class != mode.getClass() || Boolean.class != proxyTargetClass.getClass()) continue;
            candidateFound = true;
            if (mode != AdviceMode.PROXY) continue;
            AopConfigUtils.registerAutoProxyCreatorIfNecessary(registry);
            if (!((Boolean)proxyTargetClass).booleanValue()) continue;
            AopConfigUtils.forceAutoProxyCreatorToUseClassProxying(registry);
            return;
        }
        if (!candidateFound && this.logger.isWarnEnabled()) {
            String name = this.getClass().getSimpleName();
            this.logger.warn(String.format("%s was imported but no annotations were found having both 'mode' and 'proxyTargetClass' attributes of type AdviceMode and boolean respectively. This means that auto proxy creator registration and configuration may not have occurred as intended, and components may not be proxied as expected. Check to ensure that %s has been @Import'ed on the same class where these annotations are declared; otherwise remove the import of %s altogether.", name, name, name));
        }
    }
}

