/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.context.support;

import com.baidu.cloud.thirdparty.springframework.beans.BeansException;
import com.baidu.cloud.thirdparty.springframework.beans.MutablePropertyValues;
import com.baidu.cloud.thirdparty.springframework.beans.factory.support.GenericBeanDefinition;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationContext;
import com.baidu.cloud.thirdparty.springframework.context.support.GenericApplicationContext;
import com.baidu.cloud.thirdparty.springframework.context.support.StaticMessageSource;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import java.util.Locale;

public class StaticApplicationContext
extends GenericApplicationContext {
    private final StaticMessageSource staticMessageSource = new StaticMessageSource();

    public StaticApplicationContext() throws BeansException {
        this((ApplicationContext)null);
    }

    public StaticApplicationContext(@Nullable ApplicationContext parent) throws BeansException {
        super(parent);
        this.getBeanFactory().registerSingleton("messageSource", this.staticMessageSource);
    }

    @Override
    protected void assertBeanFactoryActive() {
    }

    public final StaticMessageSource getStaticMessageSource() {
        return this.staticMessageSource;
    }

    public void registerSingleton(String name, Class<?> clazz) throws BeansException {
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setBeanClass(clazz);
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, bd);
    }

    public void registerSingleton(String name, Class<?> clazz, MutablePropertyValues pvs) throws BeansException {
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setBeanClass(clazz);
        bd.setPropertyValues(pvs);
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, bd);
    }

    public void registerPrototype(String name, Class<?> clazz) throws BeansException {
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setScope("prototype");
        bd.setBeanClass(clazz);
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, bd);
    }

    public void registerPrototype(String name, Class<?> clazz, MutablePropertyValues pvs) throws BeansException {
        GenericBeanDefinition bd = new GenericBeanDefinition();
        bd.setScope("prototype");
        bd.setBeanClass(clazz);
        bd.setPropertyValues(pvs);
        this.getDefaultListableBeanFactory().registerBeanDefinition(name, bd);
    }

    public void addMessage(String code, Locale locale, String defaultMessage) {
        this.getStaticMessageSource().addMessage(code, locale, defaultMessage);
    }
}

